% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_transit_gateway_prefix_list_reference}
\alias{ec2_modify_transit_gateway_prefix_list_reference}
\title{Modifies a reference (route) to a prefix list in a specified transit
gateway route table}
\usage{
ec2_modify_transit_gateway_prefix_list_reference(
  TransitGatewayRouteTableId, PrefixListId, TransitGatewayAttachmentId,
  Blackhole, DryRun)
}
\arguments{
\item{TransitGatewayRouteTableId}{[required] The ID of the transit gateway route table.}

\item{PrefixListId}{[required] The ID of the prefix list.}

\item{TransitGatewayAttachmentId}{The ID of the attachment to which traffic is routed.}

\item{Blackhole}{Indicates whether to drop traffic that matches this route.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies a reference (route) to a prefix list in a specified transit
gateway route table.
}
\section{Request syntax}{
\preformatted{svc$modify_transit_gateway_prefix_list_reference(
  TransitGatewayRouteTableId = "string",
  PrefixListId = "string",
  TransitGatewayAttachmentId = "string",
  Blackhole = TRUE|FALSE,
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
