% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_list_tags_for_resource}
\alias{elasticbeanstalk_list_tags_for_resource}
\title{Return the tags applied to an AWS Elastic Beanstalk resource}
\usage{
elasticbeanstalk_list_tags_for_resource(ResourceArn)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resouce for which a tag list is
requested.

Must be the ARN of an Elastic Beanstalk resource.}
}
\description{
Return the tags applied to an AWS Elastic Beanstalk resource. The
response contains a list of tag key-value pairs.

Elastic Beanstalk supports tagging of all of its resources. For details
about resource tagging, see \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html}{Tagging Application Resources}.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceArn = "string"
)
}
}

\keyword{internal}
