% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_update_distribution_bundle}
\alias{lightsail_update_distribution_bundle}
\title{Updates the bundle of your Amazon Lightsail content delivery network
(CDN) distribution}
\usage{
lightsail_update_distribution_bundle(distributionName, bundleId)
}
\arguments{
\item{distributionName}{The name of the distribution for which to update the bundle.

Use the \code{GetDistributions} action to get a list of distribution names
that you can specify.}

\item{bundleId}{The bundle ID of the new bundle to apply to your distribution.

Use the \code{GetDistributionBundles} action to get a list of distribution
bundle IDs that you can specify.}
}
\description{
Updates the bundle of your Amazon Lightsail content delivery network
(CDN) distribution.

A distribution bundle specifies the monthly network transfer quota and
monthly cost of your dsitribution.

Update your distribution's bundle if your distribution is going over its
monthly network transfer quota and is incurring an overage fee.

You can update your distribution's bundle only one time within your
monthly AWS billing cycle. To determine if you can update your
distribution's bundle, use the \code{GetDistributions} action. The
\code{ableToUpdateBundle} parameter in the result will indicate whether you
can currently update your distribution's bundle.
}
\section{Request syntax}{
\preformatted{svc$update_distribution_bundle(
  distributionName = "string",
  bundleId = "string"
)
}
}

\keyword{internal}
