% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_default_vpc}
\alias{ec2_create_default_vpc}
\title{Creates a default VPC with a size /16 IPv4 CIDR block and a default
subnet in each Availability Zone}
\usage{
ec2_create_default_vpc(DryRun)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a default VPC with a size \code{/16} IPv4 CIDR block and a default
subnet in each Availability Zone. For more information about the
components of a default VPC, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html}{Default VPC and Default Subnets}
in the \emph{Amazon Virtual Private Cloud User Guide}. You cannot specify the
components of the default VPC yourself.
}
\details{
If you deleted your previous default VPC, you can create a default VPC.
You cannot have more than one default VPC per Region.

If your account supports EC2-Classic, you cannot use this action to
create a default VPC in a Region that supports EC2-Classic. If you want
a default VPC in a Region that supports EC2-Classic, see "I really want
a default VPC for my existing EC2 account. Is that possible?" in the
\href{http://aws.amazon.com/vpc/faqs/#Default_VPCs}{Default VPCs FAQ}.
}
\section{Request syntax}{
\preformatted{svc$create_default_vpc(
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
