% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_snapshots}
\alias{ec2_create_snapshots}
\title{Creates crash-consistent snapshots of multiple EBS volumes and stores
the data in S3}
\usage{
ec2_create_snapshots(Description, InstanceSpecification,
  TagSpecifications, DryRun, CopyTagsFromSource)
}
\arguments{
\item{Description}{A description propagated to every snapshot specified by the instance.}

\item{InstanceSpecification}{[required] The instance to specify which volumes should be included in the
snapshots.}

\item{TagSpecifications}{Tags to apply to every snapshot specified by the instance.}

\item{DryRun}{Checks whether you have the required permissions for the action without
actually making the request. Provides an error response. If you have the
required permissions, the error response is DryRunOperation. Otherwise,
it is UnauthorizedOperation.}

\item{CopyTagsFromSource}{Copies the tags from the specified instance to all snapshots.}
}
\description{
Creates crash-consistent snapshots of multiple EBS volumes and stores
the data in S3. Volumes are chosen by specifying an instance. Any
attached volumes will produce one snapshot each that is crash-consistent
across the instance. Boot volumes can be excluded by changing the
paramaters.
}
\section{Request syntax}{
\preformatted{svc$create_snapshots(
  Description = "string",
  InstanceSpecification = list(
    InstanceId = "string",
    ExcludeBootVolume = TRUE|FALSE
  ),
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  DryRun = TRUE|FALSE,
  CopyTagsFromSource = "volume"
)
}
}

\keyword{internal}
