% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_load_balancer_tls_certificate}
\alias{lightsail_create_load_balancer_tls_certificate}
\title{Creates a Lightsail load balancer TLS certificate}
\usage{
lightsail_create_load_balancer_tls_certificate(loadBalancerName,
  certificateName, certificateDomainName, certificateAlternativeNames,
  tags)
}
\arguments{
\item{loadBalancerName}{[required] The load balancer name where you want to create the SSL/TLS certificate.}

\item{certificateName}{[required] The SSL/TLS certificate name.

You can have up to 10 certificates in your account at one time. Each
Lightsail load balancer can have up to 2 certificates associated with it
at one time. There is also an overall limit to the number of
certificates that can be issue in a 365-day period. For more
information, see
\href{http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html}{Limits}.}

\item{certificateDomainName}{[required] The domain name (e.g., \code{example.com}) for your SSL/TLS certificate.}

\item{certificateAlternativeNames}{An array of strings listing alternative domains and subdomains for your
SSL/TLS certificate. Lightsail will de-dupe the names for you. You can
have a maximum of 9 alternative names (in addition to the 1 primary
domain). We do not support wildcards (e.g., \code{*.example.com}).}

\item{tags}{The tag keys and optional values to add to the resource during create.

To tag a resource after it has been created, see the \code{tag resource}
operation.}
}
\description{
Creates a Lightsail load balancer TLS certificate.
}
\details{
TLS is just an updated, more secure version of Secure Socket Layer
(SSL).

The \code{create load balancer tls certificate} operation supports tag-based
access control via resource tags applied to the resource identified by
loadBalancerName. For more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_load_balancer_tls_certificate(
  loadBalancerName = "string",
  certificateName = "string",
  certificateDomainName = "string",
  certificateAlternativeNames = list(
    "string"
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
