% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_authorize_security_group_ingress}
\alias{ec2_authorize_security_group_ingress}
\title{Adds the specified ingress rules to a security group}
\usage{
ec2_authorize_security_group_ingress(CidrIp, FromPort, GroupId,
  GroupName, IpPermissions, IpProtocol, SourceSecurityGroupName,
  SourceSecurityGroupOwnerId, ToPort, DryRun)
}
\arguments{
\item{CidrIp}{The IPv4 address range, in CIDR format. You can\'t specify this
parameter when specifying a source security group. To specify an IPv6
address range, use a set of IP permissions.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.}

\item{FromPort}{The start of port range for the TCP and UDP protocols, or an ICMP type
number. For the ICMP type number, use \code{-1} to specify all types. If you
specify all ICMP types, you must specify all codes.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.}

\item{GroupId}{The ID of the security group. You must specify either the security group
ID or the security group name in the request. For security groups in a
nondefault VPC, you must specify the security group ID.}

\item{GroupName}{[EC2-Classic, default VPC] The name of the security group. You must
specify either the security group ID or the security group name in the
request.}

\item{IpPermissions}{The sets of IP permissions.}

\item{IpProtocol}{The IP protocol name (\code{tcp}, \code{udp}, \code{icmp}) or number (see \href{http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml}{Protocol Numbers}).
To specify \code{icmpv6}, use a set of IP permissions.

[VPC only] Use \code{-1} to specify all protocols. If you specify \code{-1} or a
protocol other than \code{tcp}, \code{udp}, or \code{icmp}, traffic on all ports is
allowed, regardless of any ports you specify.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.}

\item{SourceSecurityGroupName}{[EC2-Classic, default VPC] The name of the source security group. You
can\'t specify this parameter in combination with the following
parameters: the CIDR IP address range, the start of the port range, the
IP protocol, and the end of the port range. Creates rules that grant
full ICMP, UDP, and TCP access. To create a rule with a specific IP
protocol and port range, use a set of IP permissions instead. For
EC2-VPC, the source security group must be in the same VPC.}

\item{SourceSecurityGroupOwnerId}{[nondefault VPC] The AWS account ID for the source security group, if
the source security group is in a different account. You can\'t specify
this parameter in combination with the following parameters: the CIDR IP
address range, the IP protocol, the start of the port range, and the end
of the port range. Creates rules that grant full ICMP, UDP, and TCP
access. To create a rule with a specific IP protocol and port range, use
a set of IP permissions instead.}

\item{ToPort}{The end of port range for the TCP and UDP protocols, or an ICMP code
number. For the ICMP code number, use \code{-1} to specify all codes. If you
specify all ICMP types, you must specify all codes.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Adds the specified ingress rules to a security group.
}
\details{
An inbound rule permits instances to receive traffic from the specified
IPv4 or IPv6 CIDR address ranges, or from the instances associated with
the specified destination security groups.

You specify a protocol for each rule (for example, TCP). For TCP and
UDP, you must also specify the destination port or port range. For
ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You
can use -1 to mean all types or all codes.

Rule changes are propagated to instances within the security group as
quickly as possible. However, a small delay might occur.

For more information about VPC security group limits, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html}{Amazon VPC Limits}.
}
\section{Request syntax}{
\preformatted{svc$authorize_security_group_ingress(
  CidrIp = "string",
  FromPort = 123,
  GroupId = "string",
  GroupName = "string",
  IpPermissions = list(
    list(
      FromPort = 123,
      IpProtocol = "string",
      IpRanges = list(
        list(
          CidrIp = "string",
          Description = "string"
        )
      ),
      Ipv6Ranges = list(
        list(
          CidrIpv6 = "string",
          Description = "string"
        )
      ),
      PrefixListIds = list(
        list(
          Description = "string",
          PrefixListId = "string"
        )
      ),
      ToPort = 123,
      UserIdGroupPairs = list(
        list(
          Description = "string",
          GroupId = "string",
          GroupName = "string",
          PeeringStatus = "string",
          UserId = "string",
          VpcId = "string",
          VpcPeeringConnectionId = "string"
        )
      )
    )
  ),
  IpProtocol = "string",
  SourceSecurityGroupName = "string",
  SourceSecurityGroupOwnerId = "string",
  ToPort = 123,
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example enables inbound traffic on TCP port 22 (SSH). The rule
# includes a description to help you identify it later.
\dontrun{svc$authorize_security_group_ingress(
  GroupId = "sg-903004f8",
  IpPermissions = list(
    list(
      FromPort = 22L,
      IpProtocol = "tcp",
      IpRanges = list(
        list(
          CidrIp = "203.0.113.0/24",
          Description = "SSH access from the LA office"
        )
      ),
      ToPort = 22L
    )
  )
)}

# This example enables inbound traffic on TCP port 80 from the specified
# security group. The group must be in the same VPC or a peer VPC.
# Incoming traffic is allowed based on the private IP addresses of
# instances that are associated with the specified security group.
\dontrun{svc$authorize_security_group_ingress(
  GroupId = "sg-111aaa22",
  IpPermissions = list(
    list(
      FromPort = 80L,
      IpProtocol = "tcp",
      ToPort = 80L,
      UserIdGroupPairs = list(
        list(
          Description = "HTTP access from other instances",
          GroupId = "sg-1a2b3c4d"
        )
      )
    )
  )
)}

# This example adds an inbound rule that allows RDP traffic from the
# specified IPv6 address range. The rule includes a description to help
# you identify it later.
\dontrun{svc$authorize_security_group_ingress(
  GroupId = "sg-123abc12 ",
  IpPermissions = list(
    list(
      FromPort = 3389L,
      IpProtocol = "tcp",
      Ipv6Ranges = list(
        list(
          CidrIpv6 = "2001:db8:1234:1a00::/64",
          Description = "RDP access from the NY office"
        )
      ),
      ToPort = 3389L
    )
  )
)}

}
\keyword{internal}
