% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_export_image_tasks}
\alias{ec2_describe_export_image_tasks}
\title{Describes the specified export image tasks or all your export image
tasks}
\usage{
ec2_describe_export_image_tasks(DryRun, Filters, ExportImageTaskIds,
  MaxResults, NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{Filter tasks using the \code{task-state} filter and one of the following
values: \code{active}, \code{completed}, \code{deleting}, or \code{deleted}.}

\item{ExportImageTaskIds}{The IDs of the export image tasks.}

\item{MaxResults}{The maximum number of results to return in a single call.}

\item{NextToken}{A token that indicates the next page of results.}
}
\description{
Describes the specified export image tasks or all your export image
tasks.
}
\section{Request syntax}{
\preformatted{svc$describe_export_image_tasks(
  DryRun = TRUE|FALSE,
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  ExportImageTaskIds = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
