% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_instance_status}
\alias{ec2_describe_instance_status}
\title{Describes the status of the specified instances or all of your instances}
\usage{
ec2_describe_instance_status(Filters, InstanceIds, MaxResults,
  NextToken, DryRun, IncludeAllInstances)
}
\arguments{
\item{Filters}{The filters.
\itemize{
\item \code{availability-zone} - The Availability Zone of the instance.
\item \code{event.code} - The code for the scheduled event (\code{instance-reboot}
\\| \code{system-reboot} \\| \code{system-maintenance} \\| \code{instance-retirement}
\\| \code{instance-stop}).
\item \code{event.description} - A description of the event.
\item \code{event.instance-event-id} - The ID of the event whose date and time
you are modifying.
\item \code{event.not-after} - The latest end time for the scheduled event (for
example, \verb{2014-09-15T17:15:20.000Z}).
\item \code{event.not-before} - The earliest start time for the scheduled event
(for example, \verb{2014-09-15T17:15:20.000Z}).
\item \code{event.not-before-deadline} - The deadline for starting the event
(for example, \verb{2014-09-15T17:15:20.000Z}).
\item \code{instance-state-code} - The code for the instance state, as a 16-bit
unsigned integer. The high byte is used for internal purposes and
should be ignored. The low byte is set based on the state
represented. The valid values are 0 (pending), 16 (running), 32
(shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
\item \code{instance-state-name} - The state of the instance (\code{pending} \\|
\code{running} \\| \code{shutting-down} \\| \code{terminated} \\| \code{stopping} \\|
\code{stopped}).
\item \code{instance-status.reachability} - Filters on instance status where
the name is \code{reachability} (\code{passed} \\| \code{failed} \\| \code{initializing}
\\| \code{insufficient-data}).
\item \code{instance-status.status} - The status of the instance (\code{ok} \\|
\code{impaired} \\| \code{initializing} \\| \code{insufficient-data} \\|
\code{not-applicable}).
\item \code{system-status.reachability} - Filters on system status where the
name is \code{reachability} (\code{passed} \\| \code{failed} \\| \code{initializing} \\|
\code{insufficient-data}).
\item \code{system-status.status} - The system status of the instance (\code{ok} \\|
\code{impaired} \\| \code{initializing} \\| \code{insufficient-data} \\|
\code{not-applicable}).
}}

\item{InstanceIds}{The instance IDs.

Default: Describes all your instances.

Constraints: Maximum 100 explicitly specified instance IDs.}

\item{MaxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another call with the returned \code{NextToken}
value. This value can be between 5 and 1000. You cannot specify this
parameter and the instance IDs parameter in the same call.}

\item{NextToken}{The token to retrieve the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{IncludeAllInstances}{When \code{true}, includes the health status for all instances. When \code{false},
includes the health status for running instances only.

Default: \code{false}}
}
\description{
Describes the status of the specified instances or all of your
instances. By default, only running instances are described, unless you
specifically indicate to return the status of all instances.
}
\details{
Instance status includes the following components:
\itemize{
\item \strong{Status checks} - Amazon EC2 performs status checks on running EC2
instances to identify hardware and software issues. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html}{Status Checks for Your Instances}
and \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html}{Troubleshooting Instances with Failed Status Checks}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
\item \strong{Scheduled events} - Amazon EC2 can schedule events (such as
reboot, stop, or terminate) for your instances related to hardware
issues, software updates, or system maintenance. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html}{Scheduled Events for Your Instances}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
\item \strong{Instance state} - You can manage your instances from the moment
you launch them through their termination. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html}{Instance Lifecycle}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
}
\section{Request syntax}{
\preformatted{svc$describe_instance_status(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  InstanceIds = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string",
  DryRun = TRUE|FALSE,
  IncludeAllInstances = TRUE|FALSE
)
}
}

\examples{
# This example describes the current status of the specified instance.
\dontrun{svc$describe_instance_status(
  InstanceIds = list(
    "i-1234567890abcdef0"
  )
)}

}
\keyword{internal}
