% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_describe_instances_health}
\alias{elasticbeanstalk_describe_instances_health}
\title{Retrieves detailed information about the health of instances in your AWS
Elastic Beanstalk}
\usage{
elasticbeanstalk_describe_instances_health(EnvironmentName,
  EnvironmentId, AttributeNames, NextToken)
}
\arguments{
\item{EnvironmentName}{Specify the AWS Elastic Beanstalk environment by name.}

\item{EnvironmentId}{Specify the AWS Elastic Beanstalk environment by ID.}

\item{AttributeNames}{Specifies the response elements you wish to receive. To retrieve all
attributes, set to \code{All}. If no attribute names are specified, returns a
list of instances.}

\item{NextToken}{Specify the pagination token returned by a previous call.}
}
\description{
Retrieves detailed information about the health of instances in your AWS
Elastic Beanstalk. This operation requires \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html}{enhanced health reporting}.
}
\section{Request syntax}{
\preformatted{svc$describe_instances_health(
  EnvironmentName = "string",
  EnvironmentId = "string",
  AttributeNames = list(
    "HealthStatus"|"Color"|"Causes"|"ApplicationMetrics"|"RefreshedAt"|"LaunchedAt"|"System"|"Deployment"|"AvailabilityZone"|"InstanceType"|"All"
  ),
  NextToken = "string"
)
}
}

\examples{
# The following operation retrieves health information for instances in an
# environment named my-env:
\dontrun{svc$describe_instances_health(
  AttributeNames = list(
    "All"
  ),
  EnvironmentName = "my-env"
)}

}
\keyword{internal}
