% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_relational_database_events}
\alias{lightsail_get_relational_database_events}
\title{Returns a list of events for a specific database in Amazon Lightsail}
\usage{
lightsail_get_relational_database_events(relationalDatabaseName,
  durationInMinutes, pageToken)
}
\arguments{
\item{relationalDatabaseName}{[required] The name of the database from which to get events.}

\item{durationInMinutes}{The number of minutes in the past from which to retrieve events. For
example, to get all events from the past 2 hours, enter 120.

Default: \code{60}

The minimum is 1 and the maximum is 14 days (20160 minutes).}

\item{pageToken}{A token used for advancing to a specific page of results from for get
relational database events request.}
}
\description{
Returns a list of events for a specific database in Amazon Lightsail.
}
\section{Request syntax}{
\preformatted{svc$get_relational_database_events(
  relationalDatabaseName = "string",
  durationInMinutes = 123,
  pageToken = "string"
)
}
}

\keyword{internal}
