% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_classic_link_instances}
\alias{ec2_describe_classic_link_instances}
\title{Describes one or more of your linked EC2-Classic instances}
\usage{
ec2_describe_classic_link_instances(Filters, DryRun, InstanceIds,
  MaxResults, NextToken)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{group-id} - The ID of a VPC security group that\'s associated with
the instance.
\item \code{instance-id} - The ID of the instance.
\item \code{tag}:\\<key\\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-id} - The ID of the VPC to which the instance is linked.

\code{vpc-id} - The ID of the VPC that the instance is linked to.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceIds}{One or more instance IDs. Must be instances linked to a VPC through
ClassicLink.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.

Constraint: If the value is greater than 1000, we return only 1000
items.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Describes one or more of your linked EC2-Classic instances. This request
only returns information about EC2-Classic instances linked to a VPC
through ClassicLink. You cannot use this request to return information
about other instances.
}
\section{Request syntax}{
\preformatted{svc$describe_classic_link_instances(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  DryRun = TRUE|FALSE,
  InstanceIds = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
