% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_client_vpn_endpoints}
\alias{ec2_describe_client_vpn_endpoints}
\title{Describes one or more Client VPN endpoints in the account}
\usage{
ec2_describe_client_vpn_endpoints(ClientVpnEndpointIds, MaxResults,
  NextToken, Filters, DryRun)
}
\arguments{
\item{ClientVpnEndpointIds}{The ID of the Client VPN endpoint.}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the nextToken value.}

\item{NextToken}{The token to retrieve the next page of results.}

\item{Filters}{One or more filters. Filter names and values are case-sensitive.
\itemize{
\item \code{endpoint-id} - The ID of the Client VPN endpoint.
\item \code{transport-protocol} - The transport protocol (\code{tcp} \\| \code{udp}).
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes one or more Client VPN endpoints in the account.
}
\section{Request syntax}{
\preformatted{svc$describe_client_vpn_endpoints(
  ClientVpnEndpointIds = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
