% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_allocate_address}
\alias{ec2_allocate_address}
\title{Allocates an Elastic IP address to your Amazon Web Services account}
\usage{
ec2_allocate_address(
  Domain = NULL,
  Address = NULL,
  PublicIpv4Pool = NULL,
  NetworkBorderGroup = NULL,
  CustomerOwnedIpv4Pool = NULL,
  DryRun = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{Domain}{Indicates whether the Elastic IP address is for use with instances in a
VPC or instances in EC2-Classic.

Default: If the Region supports EC2-Classic, the default is \code{standard}.
Otherwise, the default is \code{vpc}.}

\item{Address}{[EC2-VPC] The Elastic IP address to recover or an IPv4 address from an
address pool.}

\item{PublicIpv4Pool}{The ID of an address pool that you own. Use this parameter to let Amazon
EC2 select an address from the address pool. To specify a specific
address from the address pool, use the \code{Address} parameter instead.}

\item{NetworkBorderGroup}{A unique set of Availability Zones, Local Zones, or Wavelength Zones
from which Amazon Web Services advertises IP addresses. Use this
parameter to limit the IP address to this location. IP addresses cannot
move between network border groups.

Use \code{\link[=ec2_describe_availability_zones]{describe_availability_zones}} to
view the network border groups.

You cannot use a network border group with EC2 Classic. If you attempt
this operation on EC2 Classic, you receive an
\code{InvalidParameterCombination} error.}

\item{CustomerOwnedIpv4Pool}{The ID of a customer-owned address pool. Use this parameter to let
Amazon EC2 select an address from the address pool. Alternatively,
specify a specific address from the address pool.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{TagSpecifications}{The tags to assign to the Elastic IP address.}
}
\description{
Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address you can associate it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address pool and can be allocated to a different Amazon Web Services account.

See \url{https://paws-r.github.io/docs/ec2/allocate_address.html} for full documentation.
}
\keyword{internal}
