% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_enable_fast_launch}
\alias{ec2_enable_fast_launch}
\title{When you enable faster launching for a Windows AMI, images are
pre-provisioned, using snapshots to launch instances up to 65\% faster}
\usage{
ec2_enable_fast_launch(
  ImageId,
  ResourceType = NULL,
  SnapshotConfiguration = NULL,
  LaunchTemplate = NULL,
  MaxParallelLaunches = NULL,
  DryRun = NULL
)
}
\arguments{
\item{ImageId}{[required] The ID of the image for which you’re enabling faster launching.}

\item{ResourceType}{The type of resource to use for pre-provisioning the Windows AMI for
faster launching. Supported values include: \code{snapshot}, which is the
default value.}

\item{SnapshotConfiguration}{Configuration settings for creating and managing the snapshots that are
used for pre-provisioning the Windows AMI for faster launching. The
associated \code{ResourceType} must be \code{snapshot}.}

\item{LaunchTemplate}{The launch template to use when launching Windows instances from
pre-provisioned snapshots. Launch template parameters can include either
the name or ID of the launch template, but not both.}

\item{MaxParallelLaunches}{The maximum number of parallel instances to launch for creating
resources. Value must be \code{6} or greater.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
When you enable faster launching for a Windows AMI, images are pre-provisioned, using snapshots to launch instances up to 65\% faster. To create the optimized Windows image, Amazon EC2 launches an instance and runs through Sysprep steps, rebooting as required. Then it creates a set of reserved snapshots that are used for subsequent launches. The reserved snapshots are automatically replenished as they are used, depending on your settings for launch frequency.

See \url{https://paws-r.github.io/docs/ec2/enable_fast_launch.html} for full documentation.
}
\keyword{internal}
