% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_ipam_pool}
\alias{ec2_create_ipam_pool}
\title{Create an IP address pool for Amazon VPC IP Address Manager (IPAM)}
\usage{
ec2_create_ipam_pool(
  DryRun = NULL,
  IpamScopeId,
  Locale = NULL,
  SourceIpamPoolId = NULL,
  Description = NULL,
  AddressFamily,
  AutoImport = NULL,
  PubliclyAdvertisable = NULL,
  AllocationMinNetmaskLength = NULL,
  AllocationMaxNetmaskLength = NULL,
  AllocationDefaultNetmaskLength = NULL,
  AllocationResourceTags = NULL,
  TagSpecifications = NULL,
  ClientToken = NULL,
  AwsService = NULL,
  PublicIpSource = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamScopeId}{[required] The ID of the scope in which you would like to create the IPAM pool.}

\item{Locale}{In IPAM, the locale is the Amazon Web Services Region where you want to
make an IPAM pool available for allocations. Only resources in the same
Region as the locale of the pool can get IP address allocations from the
pool. You can only allocate a CIDR for a VPC, for example, from an IPAM
pool that shares a locale with the VPC’s Region. Note that once you
choose a Locale for a pool, you cannot modify it. If you do not choose a
locale, resources in Regions others than the IPAM's home region cannot
use CIDRs from this pool.

Possible values: Any Amazon Web Services Region, such as us-east-1.}

\item{SourceIpamPoolId}{The ID of the source IPAM pool. Use this option to create a pool within
an existing pool. Note that the CIDR you provision for the pool within
the source pool must be available in the source pool's CIDR range.}

\item{Description}{A description for the IPAM pool.}

\item{AddressFamily}{[required] The IP protocol assigned to this IPAM pool. You must choose either IPv4
or IPv6 protocol for a pool.}

\item{AutoImport}{If selected, IPAM will continuously look for resources within the CIDR
range of this pool and automatically import them as allocations into
your IPAM. The CIDRs that will be allocated for these resources must not
already be allocated to other resources in order for the import to
succeed. IPAM will import a CIDR regardless of its compliance with the
pool's allocation rules, so a resource might be imported and
subsequently marked as noncompliant. If IPAM discovers multiple CIDRs
that overlap, IPAM will import the largest CIDR only. If IPAM discovers
multiple CIDRs with matching CIDRs, IPAM will randomly import one of
them only.

A locale must be set on the pool for this feature to work.}

\item{PubliclyAdvertisable}{Determines if the pool is publicly advertisable. This option is not
available for pools with AddressFamily set to \code{ipv4}.}

\item{AllocationMinNetmaskLength}{The minimum netmask length required for CIDR allocations in this IPAM
pool to be compliant. The minimum netmask length must be less than the
maximum netmask length. Possible netmask lengths for IPv4 addresses are
0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.}

\item{AllocationMaxNetmaskLength}{The maximum netmask length possible for CIDR allocations in this IPAM
pool to be compliant. The maximum netmask length must be greater than
the minimum netmask length. Possible netmask lengths for IPv4 addresses
are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.}

\item{AllocationDefaultNetmaskLength}{The default netmask length for allocations added to this pool. If, for
example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16
here, new allocations will default to 10.0.0.0/16.}

\item{AllocationResourceTags}{Tags that are required for resources that use CIDRs from this IPAM pool.
Resources that do not have these tags will not be allowed to allocate
space from the pool. If the resources have their tags changed after they
have allocated space or if the allocation tagging requirements are
changed on the pool, the resource may be marked as noncompliant.}

\item{TagSpecifications}{The key/value combination of a tag assigned to the resource. Use the tag
key in the filter name and the tag value as the filter value. For
example, to find all resources that have a tag with the key \code{Owner} and
the value \code{TeamA}, specify \code{tag:Owner} for the filter name and \code{TeamA}
for the filter value.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{AwsService}{Limits which service in Amazon Web Services that the pool can be used
in. "ec2", for example, allows users to use space for Elastic IP
addresses and VPCs.}

\item{PublicIpSource}{The IP address source for pools in the public scope. Only used for
provisioning IP address CIDRs to pools in the public scope. Default is
\code{byoip}. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/intro-create-ipv6-pools.html}{Create IPv6 pools}
in the \emph{Amazon VPC IPAM User Guide}. By default, you can add only one
Amazon-provided IPv6 CIDR block to a top-level IPv6 pool if
PublicIpSource is \code{amazon}. For information on increasing the default
limit, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html}{Quotas for your IPAM} in
the \emph{Amazon VPC IPAM User Guide}.}
}
\description{
Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs. For example, if you have separate routing and security needs for development and production applications, you can create a pool for each.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_ipam_pool/} for full documentation.
}
\keyword{internal}
