% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagebuilder_operations.R
\name{imagebuilder_update_infrastructure_configuration}
\alias{imagebuilder_update_infrastructure_configuration}
\title{Updates a new infrastructure configuration}
\usage{
imagebuilder_update_infrastructure_configuration(
  infrastructureConfigurationArn,
  description = NULL,
  instanceTypes = NULL,
  instanceProfileName,
  securityGroupIds = NULL,
  subnetId = NULL,
  logging = NULL,
  keyPair = NULL,
  terminateInstanceOnFailure = NULL,
  snsTopicArn = NULL,
  clientToken,
  resourceTags = NULL,
  instanceMetadataOptions = NULL
)
}
\arguments{
\item{infrastructureConfigurationArn}{[required] The Amazon Resource Name (ARN) of the infrastructure configuration that
you want to update.}

\item{description}{The description of the infrastructure configuration.}

\item{instanceTypes}{The instance types of the infrastructure configuration. You can specify
one or more instance types to use for this build. The service will pick
one of these instance types based on availability.}

\item{instanceProfileName}{[required] The instance profile to associate with the instance used to customize
your Amazon EC2 AMI.}

\item{securityGroupIds}{The security group IDs to associate with the instance used to customize
your Amazon EC2 AMI.}

\item{subnetId}{The subnet ID to place the instance used to customize your Amazon EC2
AMI in.}

\item{logging}{The logging configuration of the infrastructure configuration.}

\item{keyPair}{The key pair of the infrastructure configuration. You can use this to
log on to and debug the instance used to create your image.}

\item{terminateInstanceOnFailure}{The terminate instance on failure setting of the infrastructure
configuration. Set to false if you want Image Builder to retain the
instance used to configure your AMI if the build or test phase of your
workflow fails.}

\item{snsTopicArn}{The Amazon Resource Name (ARN) for the SNS topic to which we send image
build event notifications.

EC2 Image Builder is unable to send notifications to SNS topics that are
encrypted using keys from other accounts. The key that is used to
encrypt the SNS topic must reside in the account that the Image Builder
service runs under.}

\item{clientToken}{[required] The idempotency token used to make this request idempotent.}

\item{resourceTags}{The tags attached to the resource created by Image Builder.}

\item{instanceMetadataOptions}{The instance metadata options that you can set for the HTTP requests
that pipeline builds use to launch EC2 build and test instances. For
more information about instance metadata options, see one of the
following links:
\itemize{
\item \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html}{Configure the instance metadata options}
in the \emph{Amazon EC2 User Guide} for Linux instances.
\item \href{https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html}{Configure the instance metadata options}
in the \emph{Amazon EC2 Windows Guide} for Windows instances.
}}
}
\description{
Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.

See \url{https://www.paws-r-sdk.com/docs/imagebuilder_update_infrastructure_configuration/} for full documentation.
}
\keyword{internal}
