% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_replace_network_acl_association}
\alias{ec2_replace_network_acl_association}
\title{Changes which network ACL a subnet is associated with}
\usage{
ec2_replace_network_acl_association(AssociationId, DryRun = NULL, NetworkAclId)
}
\arguments{
\item{AssociationId}{[required] The ID of the current association between the original network ACL and
the subnet.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NetworkAclId}{[required] The ID of the new network ACL to associate with the subnet.}
}
\description{
Changes which network ACL a subnet is associated with. By default when you create a subnet, it's automatically associated with the default network ACL. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html}{Network ACLs} in the \emph{Amazon VPC User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_replace_network_acl_association/} for full documentation.
}
\keyword{internal}
