% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagebuilder_operations.R
\name{imagebuilder_create_lifecycle_policy}
\alias{imagebuilder_create_lifecycle_policy}
\title{Create a lifecycle policy resource}
\usage{
imagebuilder_create_lifecycle_policy(
  name,
  description = NULL,
  status = NULL,
  executionRole,
  resourceType,
  policyDetails,
  resourceSelection,
  tags = NULL,
  clientToken
)
}
\arguments{
\item{name}{[required] The name of the lifecycle policy to create.}

\item{description}{Optional description for the lifecycle policy.}

\item{status}{Indicates whether the lifecycle policy resource is enabled.}

\item{executionRole}{[required] The name or Amazon Resource Name (ARN) for the IAM role you create that
grants Image Builder access to run lifecycle actions.}

\item{resourceType}{[required] The type of Image Builder resource that the lifecycle policy applies to.}

\item{policyDetails}{[required] Configuration details for the lifecycle policy rules.}

\item{resourceSelection}{[required] Selection criteria for the resources that the lifecycle policy applies
to.}

\item{tags}{Tags to apply to the lifecycle policy resource.}

\item{clientToken}{[required] Unique, case-sensitive identifier you provide to ensure idempotency of
the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring idempotency}
in the \emph{Amazon EC2 API Reference}.}
}
\description{
Create a lifecycle policy resource.

See \url{https://www.paws-r-sdk.com/docs/imagebuilder_create_lifecycle_policy/} for full documentation.
}
\keyword{internal}
