% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_verified_access_instance}
\alias{ec2_create_verified_access_instance}
\title{An Amazon Web Services Verified Access instance is a regional entity
that evaluates application requests and grants access only when your
security requirements are met}
\usage{
ec2_create_verified_access_instance(
  Description = NULL,
  TagSpecifications = NULL,
  ClientToken = NULL,
  DryRun = NULL,
  FIPSEnabled = NULL
)
}
\arguments{
\item{Description}{A description for the Verified Access instance.}

\item{TagSpecifications}{The tags to assign to the Verified Access instance.}

\item{ClientToken}{A unique, case-sensitive token that you provide to ensure idempotency of
your modification request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring Idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{FIPSEnabled}{Enable or disable support for Federal Information Processing Standards
(FIPS) on the instance.}
}
\description{
An Amazon Web Services Verified Access instance is a regional entity that evaluates application requests and grants access only when your security requirements are met.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_verified_access_instance/} for full documentation.
}
\keyword{internal}
