# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon EC2 Container Service
#'
#' @description
#' Amazon Elastic Container Service
#' 
#' Amazon Elastic Container Service (Amazon ECS) is a highly scalable,
#' fast, container management service. It makes it easy to run, stop, and
#' manage Docker containers. You can host your cluster on a serverless
#' infrastructure that's managed by Amazon ECS by launching your services
#' or tasks on Fargate. For more control, you can host your tasks on a
#' cluster of Amazon Elastic Compute Cloud (Amazon EC2) or External
#' (on-premises) instances that you manage.
#' 
#' Amazon ECS makes it easy to launch and stop container-based applications
#' with simple API calls. This makes it easy to get the state of your
#' cluster from a centralized service, and gives you access to many
#' familiar Amazon EC2 features.
#' 
#' You can use Amazon ECS to schedule the placement of containers across
#' your cluster based on your resource needs, isolation policies, and
#' availability requirements. With Amazon ECS, you don't need to operate
#' your own cluster management and configuration management systems. You
#' also don't need to worry about scaling your management infrastructure.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- ecs(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- ecs()
#' # This example creates a cluster in your default region.
#' svc$create_cluster(
#'   clusterName = "my_cluster"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=ecs_create_capacity_provider]{create_capacity_provider} \tab Creates a new capacity provider\cr
#'  \link[=ecs_create_cluster]{create_cluster} \tab Creates a new Amazon ECS cluster\cr
#'  \link[=ecs_create_service]{create_service} \tab Runs and maintains your desired number of tasks from a specified task definition\cr
#'  \link[=ecs_create_task_set]{create_task_set} \tab Create a task set in the specified cluster and service\cr
#'  \link[=ecs_delete_account_setting]{delete_account_setting} \tab Disables an account setting for a specified user, role, or the root user for an account\cr
#'  \link[=ecs_delete_attributes]{delete_attributes} \tab Deletes one or more custom attributes from an Amazon ECS resource\cr
#'  \link[=ecs_delete_capacity_provider]{delete_capacity_provider} \tab Deletes the specified capacity provider\cr
#'  \link[=ecs_delete_cluster]{delete_cluster} \tab Deletes the specified cluster\cr
#'  \link[=ecs_delete_service]{delete_service} \tab Deletes a specified service within a cluster\cr
#'  \link[=ecs_delete_task_definitions]{delete_task_definitions} \tab Deletes one or more task definitions\cr
#'  \link[=ecs_delete_task_set]{delete_task_set} \tab Deletes a specified task set within a service\cr
#'  \link[=ecs_deregister_container_instance]{deregister_container_instance} \tab Deregisters an Amazon ECS container instance from the specified cluster\cr
#'  \link[=ecs_deregister_task_definition]{deregister_task_definition} \tab Deregisters the specified task definition by family and revision\cr
#'  \link[=ecs_describe_capacity_providers]{describe_capacity_providers} \tab Describes one or more of your capacity providers\cr
#'  \link[=ecs_describe_clusters]{describe_clusters} \tab Describes one or more of your clusters\cr
#'  \link[=ecs_describe_container_instances]{describe_container_instances} \tab Describes one or more container instances\cr
#'  \link[=ecs_describe_services]{describe_services} \tab Describes the specified services running in your cluster\cr
#'  \link[=ecs_describe_task_definition]{describe_task_definition} \tab Describes a task definition\cr
#'  \link[=ecs_describe_tasks]{describe_tasks} \tab Describes a specified task or tasks\cr
#'  \link[=ecs_describe_task_sets]{describe_task_sets} \tab Describes the task sets in the specified cluster and service\cr
#'  \link[=ecs_discover_poll_endpoint]{discover_poll_endpoint} \tab This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent\cr
#'  \link[=ecs_execute_command]{execute_command} \tab Runs a command remotely on a container within a task\cr
#'  \link[=ecs_get_task_protection]{get_task_protection} \tab Retrieves the protection status of tasks in an Amazon ECS service\cr
#'  \link[=ecs_list_account_settings]{list_account_settings} \tab Lists the account settings for a specified principal\cr
#'  \link[=ecs_list_attributes]{list_attributes} \tab Lists the attributes for Amazon ECS resources within a specified target type and cluster\cr
#'  \link[=ecs_list_clusters]{list_clusters} \tab Returns a list of existing clusters\cr
#'  \link[=ecs_list_container_instances]{list_container_instances} \tab Returns a list of container instances in a specified cluster\cr
#'  \link[=ecs_list_services]{list_services} \tab Returns a list of services\cr
#'  \link[=ecs_list_services_by_namespace]{list_services_by_namespace} \tab This operation lists all of the services that are associated with a Cloud Map namespace\cr
#'  \link[=ecs_list_tags_for_resource]{list_tags_for_resource} \tab List the tags for an Amazon ECS resource\cr
#'  \link[=ecs_list_task_definition_families]{list_task_definition_families} \tab Returns a list of task definition families that are registered to your account\cr
#'  \link[=ecs_list_task_definitions]{list_task_definitions} \tab Returns a list of task definitions that are registered to your account\cr
#'  \link[=ecs_list_tasks]{list_tasks} \tab Returns a list of tasks\cr
#'  \link[=ecs_put_account_setting]{put_account_setting} \tab Modifies an account setting\cr
#'  \link[=ecs_put_account_setting_default]{put_account_setting_default} \tab Modifies an account setting for all users on an account for whom no individual account setting has been specified\cr
#'  \link[=ecs_put_attributes]{put_attributes} \tab Create or update an attribute on an Amazon ECS resource\cr
#'  \link[=ecs_put_cluster_capacity_providers]{put_cluster_capacity_providers} \tab Modifies the available capacity providers and the default capacity provider strategy for a cluster\cr
#'  \link[=ecs_register_container_instance]{register_container_instance} \tab This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent\cr
#'  \link[=ecs_register_task_definition]{register_task_definition} \tab Registers a new task definition from the supplied family and containerDefinitions\cr
#'  \link[=ecs_run_task]{run_task} \tab Starts a new task using the specified task definition\cr
#'  \link[=ecs_start_task]{start_task} \tab Starts a new task from the specified task definition on the specified container instance or instances\cr
#'  \link[=ecs_stop_task]{stop_task} \tab Stops a running task\cr
#'  \link[=ecs_submit_attachment_state_changes]{submit_attachment_state_changes} \tab This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent\cr
#'  \link[=ecs_submit_container_state_change]{submit_container_state_change} \tab This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent\cr
#'  \link[=ecs_submit_task_state_change]{submit_task_state_change} \tab This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent\cr
#'  \link[=ecs_tag_resource]{tag_resource} \tab Associates the specified tags to a resource with the specified resourceArn\cr
#'  \link[=ecs_untag_resource]{untag_resource} \tab Deletes specified tags from a resource\cr
#'  \link[=ecs_update_capacity_provider]{update_capacity_provider} \tab Modifies the parameters for a capacity provider\cr
#'  \link[=ecs_update_cluster]{update_cluster} \tab Updates the cluster\cr
#'  \link[=ecs_update_cluster_settings]{update_cluster_settings} \tab Modifies the settings to use for a cluster\cr
#'  \link[=ecs_update_container_agent]{update_container_agent} \tab Updates the Amazon ECS container agent on a specified container instance\cr
#'  \link[=ecs_update_container_instances_state]{update_container_instances_state} \tab Modifies the status of an Amazon ECS container instance\cr
#'  \link[=ecs_update_service]{update_service} \tab Modifies the parameters of a service\cr
#'  \link[=ecs_update_service_primary_task_set]{update_service_primary_task_set} \tab Modifies which task set in a service is the primary task set\cr
#'  \link[=ecs_update_task_protection]{update_task_protection} \tab Updates the protection status of a task\cr
#'  \link[=ecs_update_task_set]{update_task_set} \tab Modifies a task set
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname ecs
#' @export
ecs <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .ecs$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.ecs <- list()

.ecs$operations <- list()

.ecs$metadata <- list(
  service_name = "ecs",
  endpoints = list("*" = list(endpoint = "ecs.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "ecs.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "ecs.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "ecs.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "ecs.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "ecs.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "ECS",
  api_version = "2014-11-13",
  signing_name = "ecs",
  json_version = "1.1",
  target_prefix = "AmazonEC2ContainerServiceV20141113"
)

.ecs$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.ecs$metadata, handlers, config, op)
}
