% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_send_diagnostic_interrupt}
\alias{ec2_send_diagnostic_interrupt}
\title{Sends a diagnostic interrupt to the specified Amazon EC2 instance to
trigger a kernel panic (on Linux instances), or a blue screen/stop error
(on Windows instances)}
\usage{
ec2_send_diagnostic_interrupt(InstanceId, DryRun = NULL)
}
\arguments{
\item{InstanceId}{[required] The ID of the instance.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Sends a diagnostic interrupt to the specified Amazon EC2 instance to trigger a \emph{kernel panic} (on Linux instances), or a \emph{blue screen}/\emph{stop error} (on Windows instances). For instances based on Intel and AMD processors, the interrupt is received as a \emph{non-maskable interrupt} (NMI).

See \url{https://www.paws-r-sdk.com/docs/ec2_send_diagnostic_interrupt/} for full documentation.
}
\keyword{internal}
