% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_invoke_with_response_stream}
\alias{lambda_invoke_with_response_stream}
\title{Configure your Lambda functions to stream response payloads back to
clients}
\usage{
lambda_invoke_with_response_stream(
  FunctionName,
  InvocationType = NULL,
  LogType = NULL,
  ClientContext = NULL,
  Qualifier = NULL,
  Payload = NULL
)
}
\arguments{
\item{FunctionName}{[required] The name or ARN of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} – \verb{my-function}.
\item \strong{Function ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} – \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{InvocationType}{Use one of the following options:
\itemize{
\item \code{RequestResponse} (default) – Invoke the function synchronously.
Keep the connection open until the function returns a response or
times out. The API operation response includes the function response
and additional data.
\item \code{DryRun} – Validate parameter values and verify that the IAM user or
role has permission to invoke the function.
}}

\item{LogType}{Set to \code{Tail} to include the execution log in the response. Applies to
synchronously invoked functions only.}

\item{ClientContext}{Up to 3,583 bytes of base64-encoded data about the invoking client to
pass to the function in the context object.}

\item{Qualifier}{The alias name.}

\item{Payload}{The JSON that you want to provide to your Lambda function as input.

You can enter the JSON directly. For example,
\verb{--payload '\{ "key": "value" \}'}. You can also specify a file path. For
example, \verb{--payload file://payload.json}.}
}
\description{
Configure your Lambda functions to stream response payloads back to clients. For more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html}{Configuring a Lambda function to stream responses}.

See \url{https://www.paws-r-sdk.com/docs/lambda_invoke_with_response_stream/} for full documentation.
}
\keyword{internal}
