% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplacemetering_operations.R
\name{marketplacemetering_resolve_customer}
\alias{marketplacemetering_resolve_customer}
\title{ResolveCustomer is called by a SaaS application during the registration
process}
\usage{
marketplacemetering_resolve_customer(RegistrationToken)
}
\arguments{
\item{RegistrationToken}{[required] When a buyer visits your website during the registration process, the
buyer submits a registration token through the browser. The registration
token is resolved to obtain a CustomerIdentifier and product code.}
}
\value{
A list with the following syntax:\preformatted{list(
  CustomerIdentifier = "string",
  ProductCode = "string"
)
}
}
\description{
ResolveCustomer is called by a SaaS application during the registration
process. When a buyer visits your website during the registration
process, the buyer submits a registration token through their browser.
The registration token is resolved through this API to obtain a
CustomerIdentifier and product code.
}
\section{Request syntax}{
\preformatted{svc$resolve_customer(
  RegistrationToken = "string"
)
}
}

\keyword{internal}
