% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_put_identity_policy}
\alias{ses_put_identity_policy}
\title{Adds or updates a sending authorization policy for the specified
identity (an email address or a domain)}
\usage{
ses_put_identity_policy(Identity, PolicyName, Policy)
}
\arguments{
\item{Identity}{[required] The identity that the policy will apply to. You can specify an identity
by using its name or by using its Amazon Resource Name (ARN). Examples:
\code{user@example.com}, \code{example.com},
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}.

To successfully call this API, you must own the identity.}

\item{PolicyName}{[required] The name of the policy.

The policy name cannot exceed 64 characters and can only include
alphanumeric characters, dashes, and underscores.}

\item{Policy}{[required] The text of the policy in JSON format. The policy cannot exceed 4 KB.

For information about the syntax of sending authorization policies, see
the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html}{Amazon SES Developer Guide}.}
}
\description{
Adds or updates a sending authorization policy for the specified
identity (an email address or a domain).
}
\details{
This API is for the identity owner only. If you have not verified the
identity, this API will return an error.

Sending authorization is a feature that enables an identity owner to
authorize other senders to use its identities. For information about
using sending authorization, see the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$put_identity_policy(
  Identity = "string",
  PolicyName = "string",
  Policy = "string"
)
}
}

\examples{
# The following example adds a sending authorization policy to an
# identity:
\donttest{svc$put_identity_policy(
  Identity = "example.com",
  Policy = "{\\"Version\\":\\"2008-10-17\\",\\"Statement\\":[{\\"Sid\\":\\"stmt1469123904194\\",...",
  PolicyName = "MyPolicy"
)}

}
\keyword{internal}
