% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_update_configuration_set_tracking_options}
\alias{ses_update_configuration_set_tracking_options}
\title{Modifies an association between a configuration set and a custom domain
for open and click event tracking}
\usage{
ses_update_configuration_set_tracking_options(ConfigurationSetName,
  TrackingOptions)
}
\arguments{
\item{ConfigurationSetName}{[required] The name of the configuration set for which you want to update the
custom tracking domain.}

\item{TrackingOptions}{[required]}
}
\description{
Modifies an association between a configuration set and a custom domain
for open and click event tracking.
}
\details{
By default, images and links used for tracking open and click events are
hosted on domains operated by Amazon SES. You can configure a subdomain
of your own to handle these events. For information about using custom
domains, see the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html}{Amazon SES Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_configuration_set_tracking_options(
  ConfigurationSetName = "string",
  TrackingOptions = list(
    CustomRedirectDomain = "string"
  )
)
}
}

\keyword{internal}
