% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_describe_receipt_rule_set}
\alias{ses_describe_receipt_rule_set}
\title{Returns the details of the specified receipt rule set}
\usage{
ses_describe_receipt_rule_set(RuleSetName)
}
\arguments{
\item{RuleSetName}{[required] The name of the receipt rule set to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  Metadata = list(
    Name = "string",
    CreatedTimestamp = as.POSIXct(
      "2015-01-01"
    )
  ),
  Rules = list(
    list(
      Name = "string",
      Enabled = TRUE|FALSE,
      TlsPolicy = "Require"|"Optional",
      Recipients = list(
        "string"
      ),
      Actions = list(
        list(
          S3Action = list(
            TopicArn = "string",
            BucketName = "string",
            ObjectKeyPrefix = "string",
            KmsKeyArn = "string"
          ),
          BounceAction = list(
            TopicArn = "string",
            SmtpReplyCode = "string",
            StatusCode = "string",
            Message = "string",
            Sender = "string"
          ),
          WorkmailAction = list(
            TopicArn = "string",
            OrganizationArn = "string"
          ),
          LambdaAction = list(
            TopicArn = "string",
            FunctionArn = "string",
            InvocationType = "Event"|"RequestResponse"
          ),
          StopAction = list(
            Scope = "RuleSet",
            TopicArn = "string"
          ),
          AddHeaderAction = list(
            HeaderName = "string",
            HeaderValue = "string"
          ),
          SNSAction = list(
            TopicArn = "string",
            Encoding = "UTF-8"|"Base64"
          )
        )
      ),
      ScanEnabled = TRUE|FALSE
    )
  )
)
}
}
\description{
Returns the details of the specified receipt rule set.

For information about managing receipt rule sets, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$describe_receipt_rule_set(
  RuleSetName = "string"
)
}
}

\examples{
\dontrun{
# The following example returns the metadata and receipt rules of a
# receipt rule set:
svc$describe_receipt_rule_set(
  RuleSetName = "MyRuleSet"
)
}

}
\keyword{internal}
