% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_get_identity_dkim_attributes}
\alias{ses_get_identity_dkim_attributes}
\title{Returns the current status of Easy DKIM signing for an entity}
\usage{
ses_get_identity_dkim_attributes(Identities)
}
\arguments{
\item{Identities}{[required] A list of one or more verified identities - email addresses, domains, or
both.}
}
\description{
Returns the current status of Easy DKIM signing for an entity. For
domain name identities, this operation also returns the DKIM tokens that
are required for Easy DKIM signing, and whether Amazon SES has
successfully verified that these tokens have been published.
}
\details{
This operation takes a list of identities as input and returns the
following information for each:
\itemize{
\item Whether Easy DKIM signing is enabled or disabled.
\item A set of DKIM tokens that represent the identity. If the identity is
an email address, the tokens represent the domain of that address.
\item Whether Amazon SES has successfully verified the DKIM tokens
published in the domain\'s DNS. This information is only returned
for domain name identities, not for email addresses.
}

This operation is throttled at one request per second and can only get
DKIM attributes for up to 100 identities at a time.

For more information about creating DNS records using DKIM tokens, go to
the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html}{Amazon SES Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_identity_dkim_attributes(
  Identities = list(
    "string"
  )
)
}
}

\examples{
# The following example retrieves the Amazon SES Easy DKIM attributes for
# a list of identities:
\donttest{svc$get_identity_dkim_attributes(
  Identities = list(
    "example.com",
    "user@example.com"
  )
)}

}
\keyword{internal}
