# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include connect_service.R
NULL

#' Creates a user account for the specified Amazon Connect instance
#'
#' Creates a user account for the specified Amazon Connect instance.
#'
#' @usage
#' connect_create_user(Username, Password, IdentityInfo, PhoneConfig,
#'   DirectoryUserId, SecurityProfileIds, RoutingProfileId, HierarchyGroupId,
#'   InstanceId, Tags)
#'
#' @param Username &#91;required&#93; The user name for the account. For instances not using SAML for identity
#' management, the user name can include up to 20 characters. If you are
#' using SAML for identity management, the user name can include up to 64
#' characters from \[a-zA-Z0-9\\_-.\\@@\]+.
#' @param Password The password for the user account. A password is required if you are
#' using Amazon Connect for identity management. Otherwise, it is an error
#' to include a password.
#' @param IdentityInfo The information about the identity of the user.
#' @param PhoneConfig &#91;required&#93; The phone settings for the user.
#' @param DirectoryUserId The identifier of the user account in the directory used for identity
#' management. If Amazon Connect cannot access the directory, you can
#' specify this identifier to authenticate users. If you include the
#' identifier, we assume that Amazon Connect cannot access the directory.
#' Otherwise, the identity information is used to authenticate users from
#' your directory.
#' 
#' This parameter is required if you are using an existing directory for
#' identity management in Amazon Connect when Amazon Connect cannot access
#' your directory to authenticate users. If you are using SAML for identity
#' management and include this parameter, an error is returned.
#' @param SecurityProfileIds &#91;required&#93; The identifier of the security profile for the user.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile for the user.
#' @param HierarchyGroupId The identifier of the hierarchy group for the user.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param Tags One or more tags.
#'
#' @section Request syntax:
#' ```
#' svc$create_user(
#'   Username = "string",
#'   Password = "string",
#'   IdentityInfo = list(
#'     FirstName = "string",
#'     LastName = "string",
#'     Email = "string"
#'   ),
#'   PhoneConfig = list(
#'     PhoneType = "SOFT_PHONE"|"DESK_PHONE",
#'     AutoAccept = TRUE|FALSE,
#'     AfterContactWorkTimeLimit = 123,
#'     DeskPhoneNumber = "string"
#'   ),
#'   DirectoryUserId = "string",
#'   SecurityProfileIds = list(
#'     "string"
#'   ),
#'   RoutingProfileId = "string",
#'   HierarchyGroupId = "string",
#'   InstanceId = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_create_user
connect_create_user <- function(Username, Password = NULL, IdentityInfo = NULL, PhoneConfig, DirectoryUserId = NULL, SecurityProfileIds, RoutingProfileId, HierarchyGroupId = NULL, InstanceId, Tags = NULL) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "PUT",
    http_path = "/users/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_user_input(Username = Username, Password = Password, IdentityInfo = IdentityInfo, PhoneConfig = PhoneConfig, DirectoryUserId = DirectoryUserId, SecurityProfileIds = SecurityProfileIds, RoutingProfileId = RoutingProfileId, HierarchyGroupId = HierarchyGroupId, InstanceId = InstanceId, Tags = Tags)
  output <- .connect$create_user_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_user <- connect_create_user

#' Deletes a user account from the specified Amazon Connect instance
#'
#' Deletes a user account from the specified Amazon Connect instance.
#'
#' @usage
#' connect_delete_user(InstanceId, UserId)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param UserId &#91;required&#93; The identifier of the user.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user(
#'   InstanceId = "string",
#'   UserId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_delete_user
connect_delete_user <- function(InstanceId, UserId) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "DELETE",
    http_path = "/users/{InstanceId}/{UserId}",
    paginator = list()
  )
  input <- .connect$delete_user_input(InstanceId = InstanceId, UserId = UserId)
  output <- .connect$delete_user_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_user <- connect_delete_user

#' Describes the specified user account
#'
#' Describes the specified user account. You can find the instance ID in
#' the console (it's the final part of the ARN). The console does not
#' display the user IDs. Instead, list the users and note the IDs provided
#' in the output.
#'
#' @usage
#' connect_describe_user(UserId, InstanceId)
#'
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#'
#' @section Request syntax:
#' ```
#' svc$describe_user(
#'   UserId = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_describe_user
connect_describe_user <- function(UserId, InstanceId) {
  op <- new_operation(
    name = "DescribeUser",
    http_method = "GET",
    http_path = "/users/{InstanceId}/{UserId}",
    paginator = list()
  )
  input <- .connect$describe_user_input(UserId = UserId, InstanceId = InstanceId)
  output <- .connect$describe_user_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_user <- connect_describe_user

#' Describes the specified hierarchy group
#'
#' Describes the specified hierarchy group.
#'
#' @usage
#' connect_describe_user_hierarchy_group(HierarchyGroupId, InstanceId)
#'
#' @param HierarchyGroupId &#91;required&#93; The identifier of the hierarchy group.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#'
#' @section Request syntax:
#' ```
#' svc$describe_user_hierarchy_group(
#'   HierarchyGroupId = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_describe_user_hierarchy_group
connect_describe_user_hierarchy_group <- function(HierarchyGroupId, InstanceId) {
  op <- new_operation(
    name = "DescribeUserHierarchyGroup",
    http_method = "GET",
    http_path = "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}",
    paginator = list()
  )
  input <- .connect$describe_user_hierarchy_group_input(HierarchyGroupId = HierarchyGroupId, InstanceId = InstanceId)
  output <- .connect$describe_user_hierarchy_group_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_user_hierarchy_group <- connect_describe_user_hierarchy_group

#' Describes the hierarchy structure of the specified Amazon Connect
#' instance
#'
#' Describes the hierarchy structure of the specified Amazon Connect
#' instance.
#'
#' @usage
#' connect_describe_user_hierarchy_structure(InstanceId)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#'
#' @section Request syntax:
#' ```
#' svc$describe_user_hierarchy_structure(
#'   InstanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_describe_user_hierarchy_structure
connect_describe_user_hierarchy_structure <- function(InstanceId) {
  op <- new_operation(
    name = "DescribeUserHierarchyStructure",
    http_method = "GET",
    http_path = "/user-hierarchy-structure/{InstanceId}",
    paginator = list()
  )
  input <- .connect$describe_user_hierarchy_structure_input(InstanceId = InstanceId)
  output <- .connect$describe_user_hierarchy_structure_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_user_hierarchy_structure <- connect_describe_user_hierarchy_structure

#' Retrieves the contact attributes for the specified contact
#'
#' Retrieves the contact attributes for the specified contact.
#'
#' @usage
#' connect_get_contact_attributes(InstanceId, InitialContactId)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param InitialContactId &#91;required&#93; The identifier of the initial contact.
#'
#' @section Request syntax:
#' ```
#' svc$get_contact_attributes(
#'   InstanceId = "string",
#'   InitialContactId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_get_contact_attributes
connect_get_contact_attributes <- function(InstanceId, InitialContactId) {
  op <- new_operation(
    name = "GetContactAttributes",
    http_method = "GET",
    http_path = "/contact/attributes/{InstanceId}/{InitialContactId}",
    paginator = list()
  )
  input <- .connect$get_contact_attributes_input(InstanceId = InstanceId, InitialContactId = InitialContactId)
  output <- .connect$get_contact_attributes_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_contact_attributes <- connect_get_contact_attributes

#' Gets the real-time metric data from the specified Amazon Connect
#' instance
#'
#' Gets the real-time metric data from the specified Amazon Connect
#' instance.
#' 
#' For more information, see [Real-time Metrics
#' Reports](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-reports.html)
#' in the *Amazon Connect Administrator Guide*.
#'
#' @usage
#' connect_get_current_metric_data(InstanceId, Filters, Groupings,
#'   CurrentMetrics, NextToken, MaxResults)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param Filters &#91;required&#93; The queues, up to 100, or channels, to use to filter the metrics
#' returned. Metric data is retrieved only for the resources associated
#' with the queues or channels included in the filter. You can include both
#' queue IDs and queue ARNs in the same request. The only supported channel
#' is `VOICE`.
#' @param Groupings The grouping applied to the metrics returned. For example, when grouped
#' by `QUEUE`, the metrics returned apply to each queue rather than
#' aggregated for all queues. If you group by `CHANNEL`, you should include
#' a Channels filter. The only supported channel is `VOICE`.
#' 
#' If no `Grouping` is included in the request, a summary of metrics is
#' returned.
#' @param CurrentMetrics &#91;required&#93; The metrics to retrieve. Specify the name and unit for each metric. The
#' following metrics are available. For a description of each metric, see
#' [Real-time Metrics
#' Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html)
#' in the *Amazon Connect Administrator Guide*.
#' 
#' ### AGENTS\\_AFTER\\_CONTACT\\_WORK
#' 
#' Unit: COUNT
#' 
#' ### AGENTS\\_AVAILABLE
#' 
#' Unit: COUNT
#' 
#' ### AGENTS\\_ERROR
#' 
#' Unit: COUNT
#' 
#' ### AGENTS\\_NON\\_PRODUCTIVE
#' 
#' Unit: COUNT
#' 
#' ### AGENTS\\_ON\\_CALL
#' 
#' Unit: COUNT
#' 
#' ### AGENTS\\_ON\\_CONTACT
#' 
#' Unit: COUNT
#' 
#' ### AGENTS\\_ONLINE
#' 
#' Unit: COUNT
#' 
#' ### AGENTS\\_STAFFED
#' 
#' Unit: COUNT
#' 
#' ### CONTACTS\\_IN\\_QUEUE
#' 
#' Unit: COUNT
#' 
#' ### CONTACTS\\_SCHEDULED
#' 
#' Unit: COUNT
#' 
#' ### OLDEST\\_CONTACT\\_AGE
#' 
#' Unit: SECONDS
#' 
#' ### SLOTS\\_ACTIVE
#' 
#' Unit: COUNT
#' 
#' ### SLOTS\\_AVAILABLE
#' 
#' Unit: COUNT
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' 
#' The token expires after 5 minutes from the time it is created.
#' Subsequent requests that use the token must use the same request
#' parameters as the request that generated the token.
#' @param MaxResults The maximimum number of results to return per page.
#'
#' @section Request syntax:
#' ```
#' svc$get_current_metric_data(
#'   InstanceId = "string",
#'   Filters = list(
#'     Queues = list(
#'       "string"
#'     ),
#'     Channels = list(
#'       "VOICE"|"CHAT"
#'     )
#'   ),
#'   Groupings = list(
#'     "QUEUE"|"CHANNEL"
#'   ),
#'   CurrentMetrics = list(
#'     list(
#'       Name = "AGENTS_ONLINE"|"AGENTS_AVAILABLE"|"AGENTS_ON_CALL"|"AGENTS_NON_PRODUCTIVE"|"AGENTS_AFTER_CONTACT_WORK"|"AGENTS_ERROR"|"AGENTS_STAFFED"|"CONTACTS_IN_QUEUE"|"OLDEST_CONTACT_AGE"|"CONTACTS_SCHEDULED"|"AGENTS_ON_CONTACT"|"SLOTS_ACTIVE"|"SLOTS_AVAILABLE",
#'       Unit = "SECONDS"|"COUNT"|"PERCENT"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_get_current_metric_data
connect_get_current_metric_data <- function(InstanceId, Filters, Groupings = NULL, CurrentMetrics, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetCurrentMetricData",
    http_method = "POST",
    http_path = "/metrics/current/{InstanceId}",
    paginator = list()
  )
  input <- .connect$get_current_metric_data_input(InstanceId = InstanceId, Filters = Filters, Groupings = Groupings, CurrentMetrics = CurrentMetrics, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$get_current_metric_data_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_current_metric_data <- connect_get_current_metric_data

#' Retrieves a token for federation
#'
#' Retrieves a token for federation.
#'
#' @usage
#' connect_get_federation_token(InstanceId)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#'
#' @section Request syntax:
#' ```
#' svc$get_federation_token(
#'   InstanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_get_federation_token
connect_get_federation_token <- function(InstanceId) {
  op <- new_operation(
    name = "GetFederationToken",
    http_method = "GET",
    http_path = "/user/federate/{InstanceId}",
    paginator = list()
  )
  input <- .connect$get_federation_token_input(InstanceId = InstanceId)
  output <- .connect$get_federation_token_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_federation_token <- connect_get_federation_token

#' Gets historical metric data from the specified Amazon Connect instance
#'
#' Gets historical metric data from the specified Amazon Connect instance.
#' 
#' For more information, see [Historical Metrics
#' Reports](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics.html)
#' in the *Amazon Connect Administrator Guide*.
#'
#' @usage
#' connect_get_metric_data(InstanceId, StartTime, EndTime, Filters,
#'   Groupings, HistoricalMetrics, NextToken, MaxResults)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param StartTime &#91;required&#93; The timestamp, in UNIX Epoch time format, at which to start the
#' reporting interval for the retrieval of historical metrics data. The
#' time must be specified using a multiple of 5 minutes, such as 10:05,
#' 10:10, 10:15.
#' 
#' The start time cannot be earlier than 24 hours before the time of the
#' request. Historical metrics are available only for 24 hours.
#' @param EndTime &#91;required&#93; The timestamp, in UNIX Epoch time format, at which to end the reporting
#' interval for the retrieval of historical metrics data. The time must be
#' specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10,
#' and must be later than the start time timestamp.
#' 
#' The time range between the start and end time must be less than 24
#' hours.
#' @param Filters &#91;required&#93; The queues, up to 100, or channels, to use to filter the metrics
#' returned. Metric data is retrieved only for the resources associated
#' with the queues or channels included in the filter. You can include both
#' queue IDs and queue ARNs in the same request. The only supported channel
#' is `VOICE`.
#' @param Groupings The grouping applied to the metrics returned. For example, when results
#' are grouped by queue, the metrics returned are grouped by queue. The
#' values returned apply to the metrics for each queue rather than
#' aggregated for all queues.
#' 
#' The only supported grouping is `QUEUE`.
#' 
#' If no grouping is specified, a summary of metrics for all queues is
#' returned.
#' @param HistoricalMetrics &#91;required&#93; The metrics to retrieve. Specify the name, unit, and statistic for each
#' metric. The following historical metrics are available. For a
#' description of each metric, see [Historical Metrics
#' Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html)
#' in the *Amazon Connect Administrator Guide*.
#' 
#' ### ABANDON\\_TIME
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' ### AFTER\\_CONTACT\\_WORK\\_TIME
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' ### API\\_CONTACTS\\_HANDLED
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CALLBACK\\_CONTACTS\\_HANDLED
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_ABANDONED
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_AGENT\\_HUNG\\_UP\\_FIRST
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_CONSULTED
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_HANDLED
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_HANDLED\\_INCOMING
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_HANDLED\\_OUTBOUND
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_HOLD\\_ABANDONS
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_MISSED
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_QUEUED
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_TRANSFERRED\\_IN
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_TRANSFERRED\\_IN\\_FROM\\_QUEUE
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_TRANSFERRED\\_OUT
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### CONTACTS\\_TRANSFERRED\\_OUT\\_FROM\\_QUEUE
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' ### HANDLE\\_TIME
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' ### HOLD\\_TIME
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' ### INTERACTION\\_AND\\_HOLD\\_TIME
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' ### INTERACTION\\_TIME
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' ### OCCUPANCY
#' 
#' Unit: PERCENT
#' 
#' Statistic: AVG
#' 
#' ### QUEUE\\_ANSWER\\_TIME
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' ### QUEUED\\_TIME
#' 
#' Unit: SECONDS
#' 
#' Statistic: MAX
#' 
#' ### SERVICE\\_LEVEL
#' 
#' Unit: PERCENT
#' 
#' Statistic: AVG
#' 
#' Threshold: Only \"Less than\" comparisons are supported, with the
#' following service level thresholds: 15, 20, 25, 30, 45, 60, 90, 120,
#' 180, 240, 300, 600
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximimum number of results to return per page.
#'
#' @section Request syntax:
#' ```
#' svc$get_metric_data(
#'   InstanceId = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Filters = list(
#'     Queues = list(
#'       "string"
#'     ),
#'     Channels = list(
#'       "VOICE"|"CHAT"
#'     )
#'   ),
#'   Groupings = list(
#'     "QUEUE"|"CHANNEL"
#'   ),
#'   HistoricalMetrics = list(
#'     list(
#'       Name = "CONTACTS_QUEUED"|"CONTACTS_HANDLED"|"CONTACTS_ABANDONED"|"CONTACTS_CONSULTED"|"CONTACTS_AGENT_HUNG_UP_FIRST"|"CONTACTS_HANDLED_INCOMING"|"CONTACTS_HANDLED_OUTBOUND"|"CONTACTS_HOLD_ABANDONS"|"CONTACTS_TRANSFERRED_IN"|"CONTACTS_TRANSFERRED_OUT"|"CONTACTS_TRANSFERRED_IN_FROM_QUEUE"|"CONTACTS_TRANSFERRED_OUT_FROM_QUEUE"|"CONTACTS_MISSED"|"CALLBACK_CONTACTS_HANDLED"|"API_CONTACTS_HANDLED"|"OCCUPANCY"|"HANDLE_TIME"|"AFTER_CONTACT_WORK_TIME"|"QUEUED_TIME"|"ABANDON_TIME"|"QUEUE_ANSWER_TIME"|"HOLD_TIME"|"INTERACTION_TIME"|"INTERACTION_AND_HOLD_TIME"|"SERVICE_LEVEL",
#'       Threshold = list(
#'         Comparison = "LT",
#'         ThresholdValue = 123.0
#'       ),
#'       Statistic = "SUM"|"MAX"|"AVG",
#'       Unit = "SECONDS"|"COUNT"|"PERCENT"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_get_metric_data
connect_get_metric_data <- function(InstanceId, StartTime, EndTime, Filters, Groupings = NULL, HistoricalMetrics, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetMetricData",
    http_method = "POST",
    http_path = "/metrics/historical/{InstanceId}",
    paginator = list()
  )
  input <- .connect$get_metric_data_input(InstanceId = InstanceId, StartTime = StartTime, EndTime = EndTime, Filters = Filters, Groupings = Groupings, HistoricalMetrics = HistoricalMetrics, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$get_metric_data_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_metric_data <- connect_get_metric_data

#' Provides information about the contact flows for the specified Amazon
#' Connect instance
#'
#' Provides information about the contact flows for the specified Amazon
#' Connect instance.
#'
#' @usage
#' connect_list_contact_flows(InstanceId, ContactFlowTypes, NextToken,
#'   MaxResults)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param ContactFlowTypes The type of contact flow.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximimum number of results to return per page.
#'
#' @section Request syntax:
#' ```
#' svc$list_contact_flows(
#'   InstanceId = "string",
#'   ContactFlowTypes = list(
#'     "CONTACT_FLOW"|"CUSTOMER_QUEUE"|"CUSTOMER_HOLD"|"CUSTOMER_WHISPER"|"AGENT_HOLD"|"AGENT_WHISPER"|"OUTBOUND_WHISPER"|"AGENT_TRANSFER"|"QUEUE_TRANSFER"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_list_contact_flows
connect_list_contact_flows <- function(InstanceId, ContactFlowTypes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListContactFlows",
    http_method = "GET",
    http_path = "/contact-flows-summary/{InstanceId}",
    paginator = list()
  )
  input <- .connect$list_contact_flows_input(InstanceId = InstanceId, ContactFlowTypes = ContactFlowTypes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_contact_flows_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_contact_flows <- connect_list_contact_flows

#' Provides information about the hours of operation for the specified
#' Amazon Connect instance
#'
#' Provides information about the hours of operation for the specified
#' Amazon Connect instance.
#'
#' @usage
#' connect_list_hours_of_operations(InstanceId, NextToken, MaxResults)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximimum number of results to return per page.
#'
#' @section Request syntax:
#' ```
#' svc$list_hours_of_operations(
#'   InstanceId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_list_hours_of_operations
connect_list_hours_of_operations <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHoursOfOperations",
    http_method = "GET",
    http_path = "/hours-of-operations-summary/{InstanceId}",
    paginator = list()
  )
  input <- .connect$list_hours_of_operations_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_hours_of_operations_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_hours_of_operations <- connect_list_hours_of_operations

#' Provides information about the phone numbers for the specified Amazon
#' Connect instance
#'
#' Provides information about the phone numbers for the specified Amazon
#' Connect instance.
#'
#' @usage
#' connect_list_phone_numbers(InstanceId, PhoneNumberTypes,
#'   PhoneNumberCountryCodes, NextToken, MaxResults)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param PhoneNumberTypes The type of phone number.
#' @param PhoneNumberCountryCodes The ISO country code.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximimum number of results to return per page.
#'
#' @section Request syntax:
#' ```
#' svc$list_phone_numbers(
#'   InstanceId = "string",
#'   PhoneNumberTypes = list(
#'     "TOLL_FREE"|"DID"
#'   ),
#'   PhoneNumberCountryCodes = list(
#'     "AF"|"AL"|"DZ"|"AS"|"AD"|"AO"|"AI"|"AQ"|"AG"|"AR"|"AM"|"AW"|"AU"|"AT"|"AZ"|"BS"|"BH"|"BD"|"BB"|"BY"|"BE"|"BZ"|"BJ"|"BM"|"BT"|"BO"|"BA"|"BW"|"BR"|"IO"|"VG"|"BN"|"BG"|"BF"|"BI"|"KH"|"CM"|"CA"|"CV"|"KY"|"CF"|"TD"|"CL"|"CN"|"CX"|"CC"|"CO"|"KM"|"CK"|"CR"|"HR"|"CU"|"CW"|"CY"|"CZ"|"CD"|"DK"|"DJ"|"DM"|"DO"|"TL"|"EC"|"EG"|"SV"|"GQ"|"ER"|"EE"|"ET"|"FK"|"FO"|"FJ"|"FI"|"FR"|"PF"|"GA"|"GM"|"GE"|"DE"|"GH"|"GI"|"GR"|"GL"|"GD"|"GU"|"GT"|"GG"|"GN"|"GW"|"GY"|"HT"|"HN"|"HK"|"HU"|"IS"|"IN"|"ID"|"IR"|"IQ"|"IE"|"IM"|"IL"|"IT"|"CI"|"JM"|"JP"|"JE"|"JO"|"KZ"|"KE"|"KI"|"KW"|"KG"|"LA"|"LV"|"LB"|"LS"|"LR"|"LY"|"LI"|"LT"|"LU"|"MO"|"MK"|"MG"|"MW"|"MY"|"MV"|"ML"|"MT"|"MH"|"MR"|"MU"|"YT"|"MX"|"FM"|"MD"|"MC"|"MN"|"ME"|"MS"|"MA"|"MZ"|"MM"|"NA"|"NR"|"NP"|"NL"|"AN"|"NC"|"NZ"|"NI"|"NE"|"NG"|"NU"|"KP"|"MP"|"NO"|"OM"|"PK"|"PW"|"PA"|"PG"|"PY"|"PE"|"PH"|"PN"|"PL"|"PT"|"PR"|"QA"|"CG"|"RE"|"RO"|"RU"|"RW"|"BL"|"SH"|"KN"|"LC"|"MF"|"PM"|"VC"|"WS"|"SM"|"ST"|"SA"|"SN"|"RS"|"SC"|"SL"|"SG"|"SX"|"SK"|"SI"|"SB"|"SO"|"ZA"|"KR"|"ES"|"LK"|"SD"|"SR"|"SJ"|"SZ"|"SE"|"CH"|"SY"|"TW"|"TJ"|"TZ"|"TH"|"TG"|"TK"|"TO"|"TT"|"TN"|"TR"|"TM"|"TC"|"TV"|"VI"|"UG"|"UA"|"AE"|"GB"|"US"|"UY"|"UZ"|"VU"|"VA"|"VE"|"VN"|"WF"|"EH"|"YE"|"ZM"|"ZW"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_list_phone_numbers
connect_list_phone_numbers <- function(InstanceId, PhoneNumberTypes = NULL, PhoneNumberCountryCodes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPhoneNumbers",
    http_method = "GET",
    http_path = "/phone-numbers-summary/{InstanceId}",
    paginator = list()
  )
  input <- .connect$list_phone_numbers_input(InstanceId = InstanceId, PhoneNumberTypes = PhoneNumberTypes, PhoneNumberCountryCodes = PhoneNumberCountryCodes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_phone_numbers_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_phone_numbers <- connect_list_phone_numbers

#' Provides information about the queues for the specified Amazon Connect
#' instance
#'
#' Provides information about the queues for the specified Amazon Connect
#' instance.
#'
#' @usage
#' connect_list_queues(InstanceId, QueueTypes, NextToken, MaxResults)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param QueueTypes The type of queue.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximimum number of results to return per page.
#'
#' @section Request syntax:
#' ```
#' svc$list_queues(
#'   InstanceId = "string",
#'   QueueTypes = list(
#'     "STANDARD"|"AGENT"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_list_queues
connect_list_queues <- function(InstanceId, QueueTypes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListQueues",
    http_method = "GET",
    http_path = "/queues-summary/{InstanceId}",
    paginator = list()
  )
  input <- .connect$list_queues_input(InstanceId = InstanceId, QueueTypes = QueueTypes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_queues_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_queues <- connect_list_queues

#' Provides summary information about the routing profiles for the
#' specified Amazon Connect instance
#'
#' Provides summary information about the routing profiles for the
#' specified Amazon Connect instance.
#'
#' @usage
#' connect_list_routing_profiles(InstanceId, NextToken, MaxResults)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximimum number of results to return per page.
#'
#' @section Request syntax:
#' ```
#' svc$list_routing_profiles(
#'   InstanceId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_list_routing_profiles
connect_list_routing_profiles <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRoutingProfiles",
    http_method = "GET",
    http_path = "/routing-profiles-summary/{InstanceId}",
    paginator = list()
  )
  input <- .connect$list_routing_profiles_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_routing_profiles_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_routing_profiles <- connect_list_routing_profiles

#' Provides summary information about the security profiles for the
#' specified Amazon Connect instance
#'
#' Provides summary information about the security profiles for the
#' specified Amazon Connect instance.
#'
#' @usage
#' connect_list_security_profiles(InstanceId, NextToken, MaxResults)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximimum number of results to return per page.
#'
#' @section Request syntax:
#' ```
#' svc$list_security_profiles(
#'   InstanceId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_list_security_profiles
connect_list_security_profiles <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSecurityProfiles",
    http_method = "GET",
    http_path = "/security-profiles-summary/{InstanceId}",
    paginator = list()
  )
  input <- .connect$list_security_profiles_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_security_profiles_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_security_profiles <- connect_list_security_profiles

#' Lists the tags for the specified resource
#'
#' Lists the tags for the specified resource.
#'
#' @usage
#' connect_list_tags_for_resource(resourceArn)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   resourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_list_tags_for_resource
connect_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .connect$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .connect$list_tags_for_resource_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_tags_for_resource <- connect_list_tags_for_resource

#' Provides summary information about the hierarchy groups for the
#' specified Amazon Connect instance
#'
#' Provides summary information about the hierarchy groups for the
#' specified Amazon Connect instance.
#'
#' @usage
#' connect_list_user_hierarchy_groups(InstanceId, NextToken, MaxResults)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximimum number of results to return per page.
#'
#' @section Request syntax:
#' ```
#' svc$list_user_hierarchy_groups(
#'   InstanceId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_list_user_hierarchy_groups
connect_list_user_hierarchy_groups <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListUserHierarchyGroups",
    http_method = "GET",
    http_path = "/user-hierarchy-groups-summary/{InstanceId}",
    paginator = list()
  )
  input <- .connect$list_user_hierarchy_groups_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_user_hierarchy_groups_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_user_hierarchy_groups <- connect_list_user_hierarchy_groups

#' Provides summary information about the users for the specified Amazon
#' Connect instance
#'
#' Provides summary information about the users for the specified Amazon
#' Connect instance.
#'
#' @usage
#' connect_list_users(InstanceId, NextToken, MaxResults)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximimum number of results to return per page.
#'
#' @section Request syntax:
#' ```
#' svc$list_users(
#'   InstanceId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_list_users
connect_list_users <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "GET",
    http_path = "/users-summary/{InstanceId}",
    paginator = list()
  )
  input <- .connect$list_users_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_users_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_users <- connect_list_users

#' When a contact is being recorded, and the recording has been suspended
#' using SuspendContactRecording, this API resumes recording the call
#'
#' When a contact is being recorded, and the recording has been suspended
#' using SuspendContactRecording, this API resumes recording the call.
#' 
#' Only voice recordings are supported at this time.
#'
#' @usage
#' connect_resume_contact_recording(InstanceId, ContactId,
#'   InitialContactId)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param InitialContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with the contact center.
#'
#' @section Request syntax:
#' ```
#' svc$resume_contact_recording(
#'   InstanceId = "string",
#'   ContactId = "string",
#'   InitialContactId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_resume_contact_recording
connect_resume_contact_recording <- function(InstanceId, ContactId, InitialContactId) {
  op <- new_operation(
    name = "ResumeContactRecording",
    http_method = "POST",
    http_path = "/contact/resume-recording",
    paginator = list()
  )
  input <- .connect$resume_contact_recording_input(InstanceId = InstanceId, ContactId = ContactId, InitialContactId = InitialContactId)
  output <- .connect$resume_contact_recording_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$resume_contact_recording <- connect_resume_contact_recording

#' Initiates a contact flow to start a new chat for the customer
#'
#' Initiates a contact flow to start a new chat for the customer. Response
#' of this API provides a token required to obtain credentials from the
#' [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html)
#' API in the Amazon Connect Participant Service.
#' 
#' When a new chat contact is successfully created, clients need to
#' subscribe to the participant's connection for the created chat within 5
#' minutes. This is achieved by invoking
#' [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html)
#' with WEBSOCKET and CONNECTION\\_CREDENTIALS.
#'
#' @usage
#' connect_start_chat_contact(InstanceId, ContactFlowId, Attributes,
#'   ParticipantDetails, InitialMessage, ClientToken)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param ContactFlowId &#91;required&#93; The identifier of the contact flow for the chat.
#' @param Attributes A custom key-value pair using an attribute map. The attributes are
#' standard Amazon Connect attributes, and can be accessed in contact flows
#' just like any other contact attributes.
#' 
#' There can be up to 32,768 UTF-8 bytes across all key-value pairs per
#' contact. Attribute keys can include only alphanumeric, dash, and
#' underscore characters.
#' @param ParticipantDetails &#91;required&#93; Information identifying the participant.
#' @param InitialMessage The initial message to be sent to the newly created chat.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$start_chat_contact(
#'   InstanceId = "string",
#'   ContactFlowId = "string",
#'   Attributes = list(
#'     "string"
#'   ),
#'   ParticipantDetails = list(
#'     DisplayName = "string"
#'   ),
#'   InitialMessage = list(
#'     ContentType = "string",
#'     Content = "string"
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_start_chat_contact
connect_start_chat_contact <- function(InstanceId, ContactFlowId, Attributes = NULL, ParticipantDetails, InitialMessage = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "StartChatContact",
    http_method = "PUT",
    http_path = "/contact/chat",
    paginator = list()
  )
  input <- .connect$start_chat_contact_input(InstanceId = InstanceId, ContactFlowId = ContactFlowId, Attributes = Attributes, ParticipantDetails = ParticipantDetails, InitialMessage = InitialMessage, ClientToken = ClientToken)
  output <- .connect$start_chat_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$start_chat_contact <- connect_start_chat_contact

#' This API starts recording the contact when the agent joins the call
#'
#' This API starts recording the contact when the agent joins the call.
#' StartContactRecording is a one-time action. For example, if you use
#' StopContactRecording to stop recording an ongoing call, you can\'t use
#' StartContactRecording to restart it. For scenarios where the recording
#' has started and you want to suspend and resume it, such as when
#' collecting sensitive information (for example, a credit card number),
#' use SuspendContactRecording and ResumeContactRecording.
#' 
#' You can use this API to override the recording behavior configured in
#' the [Set recording
#' behavior](https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html)
#' block.
#' 
#' Only voice recordings are supported at this time.
#'
#' @usage
#' connect_start_contact_recording(InstanceId, ContactId, InitialContactId,
#'   VoiceRecordingConfiguration)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param InitialContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with the contact center.
#' @param VoiceRecordingConfiguration &#91;required&#93; Who is being recorded.
#'
#' @section Request syntax:
#' ```
#' svc$start_contact_recording(
#'   InstanceId = "string",
#'   ContactId = "string",
#'   InitialContactId = "string",
#'   VoiceRecordingConfiguration = list(
#'     VoiceRecordingTrack = "FROM_AGENT"|"TO_AGENT"|"ALL"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_start_contact_recording
connect_start_contact_recording <- function(InstanceId, ContactId, InitialContactId, VoiceRecordingConfiguration) {
  op <- new_operation(
    name = "StartContactRecording",
    http_method = "POST",
    http_path = "/contact/start-recording",
    paginator = list()
  )
  input <- .connect$start_contact_recording_input(InstanceId = InstanceId, ContactId = ContactId, InitialContactId = InitialContactId, VoiceRecordingConfiguration = VoiceRecordingConfiguration)
  output <- .connect$start_contact_recording_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$start_contact_recording <- connect_start_contact_recording

#' This API places an outbound call to a contact, and then initiates the
#' contact flow
#'
#' This API places an outbound call to a contact, and then initiates the
#' contact flow. It performs the actions in the contact flow that\'s
#' specified (in `ContactFlowId`).
#' 
#' Agents are not involved in initiating the outbound API (that is, dialing
#' the contact). If the contact flow places an outbound call to a contact,
#' and then puts the contact in queue, that\'s when the call is routed to
#' the agent, like any other inbound case.
#' 
#' There is a 60 second dialing timeout for this operation. If the call is
#' not connected after 60 seconds, it fails.
#'
#' @usage
#' connect_start_outbound_voice_contact(DestinationPhoneNumber,
#'   ContactFlowId, InstanceId, ClientToken, SourcePhoneNumber, QueueId,
#'   Attributes)
#'
#' @param DestinationPhoneNumber &#91;required&#93; The phone number of the customer, in E.164 format.
#' @param ContactFlowId &#91;required&#93; The identifier of the contact flow for the outbound call.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. The token is valid for 7 days after
#' creation. If a contact is already started, the contact ID is returned.
#' If the contact is disconnected, a new contact is started.
#' @param SourcePhoneNumber The phone number associated with the Amazon Connect instance, in E.164
#' format. If you do not specify a source phone number, you must specify a
#' queue.
#' @param QueueId The queue for the call. If you specify a queue, the phone displayed for
#' caller ID is the phone number specified in the queue. If you do not
#' specify a queue, the queue defined in the contact flow is used. If you
#' do not specify a queue, you must specify a source phone number.
#' @param Attributes A custom key-value pair using an attribute map. The attributes are
#' standard Amazon Connect attributes, and can be accessed in contact flows
#' just like any other contact attributes.
#' 
#' There can be up to 32,768 UTF-8 bytes across all key-value pairs per
#' contact. Attribute keys can include only alphanumeric, dash, and
#' underscore characters.
#'
#' @section Request syntax:
#' ```
#' svc$start_outbound_voice_contact(
#'   DestinationPhoneNumber = "string",
#'   ContactFlowId = "string",
#'   InstanceId = "string",
#'   ClientToken = "string",
#'   SourcePhoneNumber = "string",
#'   QueueId = "string",
#'   Attributes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_start_outbound_voice_contact
connect_start_outbound_voice_contact <- function(DestinationPhoneNumber, ContactFlowId, InstanceId, ClientToken = NULL, SourcePhoneNumber = NULL, QueueId = NULL, Attributes = NULL) {
  op <- new_operation(
    name = "StartOutboundVoiceContact",
    http_method = "PUT",
    http_path = "/contact/outbound-voice",
    paginator = list()
  )
  input <- .connect$start_outbound_voice_contact_input(DestinationPhoneNumber = DestinationPhoneNumber, ContactFlowId = ContactFlowId, InstanceId = InstanceId, ClientToken = ClientToken, SourcePhoneNumber = SourcePhoneNumber, QueueId = QueueId, Attributes = Attributes)
  output <- .connect$start_outbound_voice_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$start_outbound_voice_contact <- connect_start_outbound_voice_contact

#' Ends the specified contact
#'
#' Ends the specified contact.
#'
#' @usage
#' connect_stop_contact(ContactId, InstanceId)
#'
#' @param ContactId &#91;required&#93; The ID of the contact.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#'
#' @section Request syntax:
#' ```
#' svc$stop_contact(
#'   ContactId = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_stop_contact
connect_stop_contact <- function(ContactId, InstanceId) {
  op <- new_operation(
    name = "StopContact",
    http_method = "POST",
    http_path = "/contact/stop",
    paginator = list()
  )
  input <- .connect$stop_contact_input(ContactId = ContactId, InstanceId = InstanceId)
  output <- .connect$stop_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$stop_contact <- connect_stop_contact

#' When a contact is being recorded, this API stops recording the call
#'
#' When a contact is being recorded, this API stops recording the call.
#' StopContactRecording is a one-time action. If you use
#' StopContactRecording to stop recording an ongoing call, you can\'t use
#' StartContactRecording to restart it. For scenarios where the recording
#' has started and you want to suspend it for sensitive information (for
#' example, to collect a credit card number), and then restart it, use
#' SuspendContactRecording and ResumeContactRecording.
#' 
#' Only voice recordings are supported at this time.
#'
#' @usage
#' connect_stop_contact_recording(InstanceId, ContactId, InitialContactId)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param InitialContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with the contact center.
#'
#' @section Request syntax:
#' ```
#' svc$stop_contact_recording(
#'   InstanceId = "string",
#'   ContactId = "string",
#'   InitialContactId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_stop_contact_recording
connect_stop_contact_recording <- function(InstanceId, ContactId, InitialContactId) {
  op <- new_operation(
    name = "StopContactRecording",
    http_method = "POST",
    http_path = "/contact/stop-recording",
    paginator = list()
  )
  input <- .connect$stop_contact_recording_input(InstanceId = InstanceId, ContactId = ContactId, InitialContactId = InitialContactId)
  output <- .connect$stop_contact_recording_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$stop_contact_recording <- connect_stop_contact_recording

#' When a contact is being recorded, this API suspends recording the call
#'
#' When a contact is being recorded, this API suspends recording the call.
#' For example, you might suspend the call recording while collecting
#' sensitive information, such as a credit card number. Then use
#' ResumeContactRecording to restart recording.
#' 
#' The period of time that the recording is suspended is filled with
#' silence in the final recording.
#' 
#' Only voice recordings are supported at this time.
#'
#' @usage
#' connect_suspend_contact_recording(InstanceId, ContactId,
#'   InitialContactId)
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param InitialContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with the contact center.
#'
#' @section Request syntax:
#' ```
#' svc$suspend_contact_recording(
#'   InstanceId = "string",
#'   ContactId = "string",
#'   InitialContactId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_suspend_contact_recording
connect_suspend_contact_recording <- function(InstanceId, ContactId, InitialContactId) {
  op <- new_operation(
    name = "SuspendContactRecording",
    http_method = "POST",
    http_path = "/contact/suspend-recording",
    paginator = list()
  )
  input <- .connect$suspend_contact_recording_input(InstanceId = InstanceId, ContactId = ContactId, InitialContactId = InitialContactId)
  output <- .connect$suspend_contact_recording_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$suspend_contact_recording <- connect_suspend_contact_recording

#' Adds the specified tags to the specified resource
#'
#' Adds the specified tags to the specified resource.
#' 
#' The supported resource type is users.
#'
#' @usage
#' connect_tag_resource(resourceArn, tags)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; One or more tags. For example, \{ \"tags\": \{\"key1\":\"value1\",
#' \"key2\":\"value2\"\} \}.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   resourceArn = "string",
#'   tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_tag_resource
connect_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .connect$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .connect$tag_resource_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$tag_resource <- connect_tag_resource

#' Removes the specified tags from the specified resource
#'
#' Removes the specified tags from the specified resource.
#'
#' @usage
#' connect_untag_resource(resourceArn, tagKeys)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys &#91;required&#93; The tag keys.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   resourceArn = "string",
#'   tagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_untag_resource
connect_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .connect$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .connect$untag_resource_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$untag_resource <- connect_untag_resource

#' Creates or updates the contact attributes associated with the specified
#' contact
#'
#' Creates or updates the contact attributes associated with the specified
#' contact.
#' 
#' You can add or update attributes for both ongoing and completed
#' contacts. For example, you can update the customer\'s name or the reason
#' the customer called while the call is active, or add notes about steps
#' that the agent took during the call that are displayed to the next agent
#' that takes the call. You can also update attributes for a contact using
#' data from your CRM application and save the data with the contact in
#' Amazon Connect. You could also flag calls for additional analysis, such
#' as legal review or identifying abusive callers.
#' 
#' Contact attributes are available in Amazon Connect for 24 months, and
#' are then deleted.
#' 
#' **Important:** You cannot use the operation to update attributes for
#' contacts that occurred prior to the release of the API, September 12,
#' 2018. You can update attributes only for contacts that started after the
#' release of the API. If you attempt to update attributes for a contact
#' that occurred prior to the release of the API, a 400 error is returned.
#' This applies also to queued callbacks that were initiated prior to the
#' release of the API but are still active in your instance.
#'
#' @usage
#' connect_update_contact_attributes(InitialContactId, InstanceId,
#'   Attributes)
#'
#' @param InitialContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with the contact center.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param Attributes &#91;required&#93; The Amazon Connect attributes. These attributes can be accessed in
#' contact flows just like any other contact attributes.
#' 
#' You can have up to 32,768 UTF-8 bytes across all attributes for a
#' contact. Attribute keys can include only alphanumeric, dash, and
#' underscore characters.
#'
#' @section Request syntax:
#' ```
#' svc$update_contact_attributes(
#'   InitialContactId = "string",
#'   InstanceId = "string",
#'   Attributes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_update_contact_attributes
connect_update_contact_attributes <- function(InitialContactId, InstanceId, Attributes) {
  op <- new_operation(
    name = "UpdateContactAttributes",
    http_method = "POST",
    http_path = "/contact/attributes",
    paginator = list()
  )
  input <- .connect$update_contact_attributes_input(InitialContactId = InitialContactId, InstanceId = InstanceId, Attributes = Attributes)
  output <- .connect$update_contact_attributes_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_contact_attributes <- connect_update_contact_attributes

#' Assigns the specified hierarchy group to the specified user
#'
#' Assigns the specified hierarchy group to the specified user.
#'
#' @usage
#' connect_update_user_hierarchy(HierarchyGroupId, UserId, InstanceId)
#'
#' @param HierarchyGroupId The identifier of the hierarchy group.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#'
#' @section Request syntax:
#' ```
#' svc$update_user_hierarchy(
#'   HierarchyGroupId = "string",
#'   UserId = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_update_user_hierarchy
connect_update_user_hierarchy <- function(HierarchyGroupId = NULL, UserId, InstanceId) {
  op <- new_operation(
    name = "UpdateUserHierarchy",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/hierarchy",
    paginator = list()
  )
  input <- .connect$update_user_hierarchy_input(HierarchyGroupId = HierarchyGroupId, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$update_user_hierarchy_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_hierarchy <- connect_update_user_hierarchy

#' Updates the identity information for the specified user
#'
#' Updates the identity information for the specified user.
#'
#' @usage
#' connect_update_user_identity_info(IdentityInfo, UserId, InstanceId)
#'
#' @param IdentityInfo &#91;required&#93; The identity information for the user.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#'
#' @section Request syntax:
#' ```
#' svc$update_user_identity_info(
#'   IdentityInfo = list(
#'     FirstName = "string",
#'     LastName = "string",
#'     Email = "string"
#'   ),
#'   UserId = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_update_user_identity_info
connect_update_user_identity_info <- function(IdentityInfo, UserId, InstanceId) {
  op <- new_operation(
    name = "UpdateUserIdentityInfo",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/identity-info",
    paginator = list()
  )
  input <- .connect$update_user_identity_info_input(IdentityInfo = IdentityInfo, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$update_user_identity_info_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_identity_info <- connect_update_user_identity_info

#' Updates the phone configuration settings for the specified user
#'
#' Updates the phone configuration settings for the specified user.
#'
#' @usage
#' connect_update_user_phone_config(PhoneConfig, UserId, InstanceId)
#'
#' @param PhoneConfig &#91;required&#93; Information about phone configuration settings for the user.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#'
#' @section Request syntax:
#' ```
#' svc$update_user_phone_config(
#'   PhoneConfig = list(
#'     PhoneType = "SOFT_PHONE"|"DESK_PHONE",
#'     AutoAccept = TRUE|FALSE,
#'     AfterContactWorkTimeLimit = 123,
#'     DeskPhoneNumber = "string"
#'   ),
#'   UserId = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_update_user_phone_config
connect_update_user_phone_config <- function(PhoneConfig, UserId, InstanceId) {
  op <- new_operation(
    name = "UpdateUserPhoneConfig",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/phone-config",
    paginator = list()
  )
  input <- .connect$update_user_phone_config_input(PhoneConfig = PhoneConfig, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$update_user_phone_config_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_phone_config <- connect_update_user_phone_config

#' Assigns the specified routing profile to the specified user
#'
#' Assigns the specified routing profile to the specified user.
#'
#' @usage
#' connect_update_user_routing_profile(RoutingProfileId, UserId,
#'   InstanceId)
#'
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile for the user.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#'
#' @section Request syntax:
#' ```
#' svc$update_user_routing_profile(
#'   RoutingProfileId = "string",
#'   UserId = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_update_user_routing_profile
connect_update_user_routing_profile <- function(RoutingProfileId, UserId, InstanceId) {
  op <- new_operation(
    name = "UpdateUserRoutingProfile",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/routing-profile",
    paginator = list()
  )
  input <- .connect$update_user_routing_profile_input(RoutingProfileId = RoutingProfileId, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$update_user_routing_profile_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_routing_profile <- connect_update_user_routing_profile

#' Assigns the specified security profiles to the specified user
#'
#' Assigns the specified security profiles to the specified user.
#'
#' @usage
#' connect_update_user_security_profiles(SecurityProfileIds, UserId,
#'   InstanceId)
#'
#' @param SecurityProfileIds &#91;required&#93; The identifiers of the security profiles for the user.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#'
#' @section Request syntax:
#' ```
#' svc$update_user_security_profiles(
#'   SecurityProfileIds = list(
#'     "string"
#'   ),
#'   UserId = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname connect_update_user_security_profiles
connect_update_user_security_profiles <- function(SecurityProfileIds, UserId, InstanceId) {
  op <- new_operation(
    name = "UpdateUserSecurityProfiles",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/security-profiles",
    paginator = list()
  )
  input <- .connect$update_user_security_profiles_input(SecurityProfileIds = SecurityProfileIds, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$update_user_security_profiles_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_security_profiles <- connect_update_user_security_profiles
