% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_get_application_date_range_kpi}
\alias{pinpoint_get_application_date_range_kpi}
\title{Retrieves (queries) pre-aggregated data for a standard metric that
applies to an application}
\usage{
pinpoint_get_application_date_range_kpi(
  ApplicationId,
  EndTime = NULL,
  KpiName,
  NextToken = NULL,
  PageSize = NULL,
  StartTime = NULL
)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}

\item{EndTime}{The last date and time to retrieve data for, as part of an inclusive
date range that filters the query results. This value should be in
extended ISO 8601 format and use Coordinated Universal Time (UTC), for
example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.}

\item{KpiName}{[required] The name of the metric, also referred to as a \emph{key performance indicator
(KPI)}, to retrieve data for. This value describes the associated metric
and consists of two or more terms, which are comprised of lowercase
alphanumeric characters, separated by a hyphen. Examples are
email-open-rate and successful-delivery-rate. For a list of valid
values, see the \href{https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html}{Amazon Pinpoint Developer Guide}.}

\item{NextToken}{The string that specifies which page of results to return in a paginated
response. This parameter is not supported for application, campaign, and
journey metrics.}

\item{PageSize}{The maximum number of items to include in each page of a paginated
response. This parameter is not supported for application, campaign, and
journey metrics.}

\item{StartTime}{The first date and time to retrieve data for, as part of an inclusive
date range that filters the query results. This value should be in
extended ISO 8601 format and use Coordinated Universal Time (UTC), for
example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value
should also be fewer than 90 days from the current day.}
}
\description{
Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.

See \url{https://paws-r.github.io/docs/pinpoint/get_application_date_range_kpi.html} for full documentation.
}
\keyword{internal}
