% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_describe_cache_clusters}
\alias{elasticache_describe_cache_clusters}
\title{Returns information about all provisioned clusters if no cluster
identifier is specified, or about a specific cache cluster if a cluster
identifier is supplied}
\usage{
elasticache_describe_cache_clusters(CacheClusterId, MaxRecords, Marker,
  ShowCacheNodeInfo, ShowCacheClustersNotInReplicationGroups)
}
\arguments{
\item{CacheClusterId}{The user-supplied cluster identifier. If this parameter is specified,
only information about that specific cluster is returned. This parameter
isn't case sensitive.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a marker is
included in the response so that the remaining results can be retrieved.

Default: 100

Constraints: minimum 20; maximum 100.}

\item{Marker}{An optional marker returned from a prior request. Use this marker for
pagination of results from this operation. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}

\item{ShowCacheNodeInfo}{An optional flag that can be included in the \code{DescribeCacheCluster}
request to retrieve information about the individual cache nodes.}

\item{ShowCacheClustersNotInReplicationGroups}{An optional flag that can be included in the \code{DescribeCacheCluster}
request to show only nodes (API/CLI: clusters) that are not members of a
replication group. In practice, this mean Memcached and single node
Redis clusters.}
}
\description{
Returns information about all provisioned clusters if no cluster
identifier is specified, or about a specific cache cluster if a cluster
identifier is supplied.

By default, abbreviated information about the clusters is returned. You
can use the optional \emph{ShowCacheNodeInfo} flag to retrieve detailed
information about the cache nodes associated with the clusters. These
details include the DNS address and port for the cache node endpoint.

If the cluster is in the \emph{creating} state, only cluster-level
information is displayed until all of the nodes are successfully
provisioned.

If the cluster is in the \emph{deleting} state, only cluster-level
information is displayed.

If cache nodes are currently being added to the cluster, node endpoint
information and creation time for the additional nodes are not displayed
until they are completely provisioned. When the cluster state is
\emph{available}, the cluster is ready for use.

If cache nodes are currently being removed from the cluster, no endpoint
information for the removed nodes is displayed.
}
\section{Request syntax}{
\preformatted{svc$describe_cache_clusters(
  CacheClusterId = "string",
  MaxRecords = 123,
  Marker = "string",
  ShowCacheNodeInfo = TRUE|FALSE,
  ShowCacheClustersNotInReplicationGroups = TRUE|FALSE
)
}
}

\keyword{internal}
