% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_orderable_db_instance_options}
\alias{rds_describe_orderable_db_instance_options}
\title{Returns a list of orderable DB instance options for the specified engine}
\usage{
rds_describe_orderable_db_instance_options(Engine, EngineVersion,
  DBInstanceClass, LicenseModel, AvailabilityZoneGroup, Vpc, Filters,
  MaxRecords, Marker)
}
\arguments{
\item{Engine}{[required] The name of the engine to retrieve DB instance options for.}

\item{EngineVersion}{The engine version filter value. Specify this parameter to show only the
available offerings matching the specified engine version.}

\item{DBInstanceClass}{The DB instance class filter value. Specify this parameter to show only
the available offerings matching the specified DB instance class.}

\item{LicenseModel}{The license model filter value. Specify this parameter to show only the
available offerings matching the specified license model.}

\item{AvailabilityZoneGroup}{The Availability Zone group associated with a Local Zone. Specify this
parameter to retrieve available offerings for the Local Zones in the
group.

Omit this parameter to show the available offerings in the specified AWS
Region.}

\item{Vpc}{A value that indicates whether to show only VPC or non-VPC offerings.}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
DescribeOrderableDBInstanceOptions request. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords} .}
}
\description{
Returns a list of orderable DB instance options for the specified
engine.
}
\section{Request syntax}{
\preformatted{svc$describe_orderable_db_instance_options(
  Engine = "string",
  EngineVersion = "string",
  DBInstanceClass = "string",
  LicenseModel = "string",
  AvailabilityZoneGroup = "string",
  Vpc = TRUE|FALSE,
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
