% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_describe_valid_db_instance_modifications}
\alias{neptune_describe_valid_db_instance_modifications}
\title{You can call DescribeValidDBInstanceModifications to learn what
modifications you can make to your DB instance}
\usage{
neptune_describe_valid_db_instance_modifications(DBInstanceIdentifier)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The customer identifier or the ARN of your DB instance.}
}
\value{
A list with the following syntax:\preformatted{list(
  ValidDBInstanceModificationsMessage = list(
    Storage = list(
      list(
        StorageType = "string",
        StorageSize = list(
          list(
            From = 123,
            To = 123,
            Step = 123
          )
        ),
        ProvisionedIops = list(
          list(
            From = 123,
            To = 123,
            Step = 123
          )
        ),
        IopsToStorageRatio = list(
          list(
            From = 123.0,
            To = 123.0
          )
        )
      )
    )
  )
)
}
}
\description{
You can call
\code{\link[=neptune_describe_valid_db_instance_modifications]{describe_valid_db_instance_modifications}}
to learn what modifications you can make to your DB instance. You can
use this information when you call
\code{\link[=neptune_modify_db_instance]{modify_db_instance}}.
}
\section{Request syntax}{
\preformatted{svc$describe_valid_db_instance_modifications(
  DBInstanceIdentifier = "string"
)
}
}

\keyword{internal}
