% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_event_subscription}
\alias{rds_create_event_subscription}
\title{Creates an RDS event notification subscription}
\usage{
rds_create_event_subscription(SubscriptionName, SnsTopicArn, SourceType,
  EventCategories, SourceIds, Enabled, Tags)
}
\arguments{
\item{SubscriptionName}{[required] The name of the subscription.

Constraints: The name must be less than 255 characters.}

\item{SnsTopicArn}{[required] The Amazon Resource Name (ARN) of the SNS topic created for event
notification. The ARN is created by Amazon SNS when you create a topic
and subscribe to it.}

\item{SourceType}{The type of source that is generating the events. For example, if you
want to be notified of events generated by a DB instance, you set this
parameter to \code{db-instance}. If this value isn't specified, all events
are returned.

Valid values: \code{db-instance} | \code{db-cluster} | \code{db-parameter-group} |
\code{db-security-group} | \code{db-snapshot} | \code{db-cluster-snapshot}}

\item{EventCategories}{A list of event categories for a particular source type (\code{SourceType})
that you want to subscribe to. You can see a list of the categories for
a given source type in
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html}{Events}
in the \emph{Amazon RDS User Guide} or by using the
\code{\link[=rds_describe_event_categories]{describe_event_categories}} operation.}

\item{SourceIds}{The list of identifiers of the event sources for which events are
returned. If not specified, then all sources are included in the
response. An identifier must begin with a letter and must contain only
ASCII letters, digits, and hyphens. It can't end with a hyphen or
contain two consecutive hyphens.

Constraints:
\itemize{
\item If a \code{SourceIds} value is supplied, \code{SourceType} must also be
provided.
\item If the source type is a DB instance, a \code{DBInstanceIdentifier} value
must be supplied.
\item If the source type is a DB cluster, a \code{DBClusterIdentifier} value
must be supplied.
\item If the source type is a DB parameter group, a \code{DBParameterGroupName}
value must be supplied.
\item If the source type is a DB security group, a \code{DBSecurityGroupName}
value must be supplied.
\item If the source type is a DB snapshot, a \code{DBSnapshotIdentifier} value
must be supplied.
\item If the source type is a DB cluster snapshot, a
\code{DBClusterSnapshotIdentifier} value must be supplied.
}}

\item{Enabled}{A value that indicates whether to activate the subscription. If the
event notification subscription isn't activated, the subscription is
created but not active.}

\item{Tags}{}
}
\value{
A list with the following syntax:\preformatted{list(
  EventSubscription = list(
    CustomerAwsId = "string",
    CustSubscriptionId = "string",
    SnsTopicArn = "string",
    Status = "string",
    SubscriptionCreationTime = "string",
    SourceType = "string",
    SourceIdsList = list(
      "string"
    ),
    EventCategoriesList = list(
      "string"
    ),
    Enabled = TRUE|FALSE,
    EventSubscriptionArn = "string"
  )
)
}
}
\description{
Creates an RDS event notification subscription. This action requires a
topic Amazon Resource Name (ARN) created by either the RDS console, the
SNS console, or the SNS API. To obtain an ARN with SNS, you must create
a topic in Amazon SNS and subscribe to the topic. The ARN is displayed
in the SNS console.

You can specify the type of source (\code{SourceType}) that you want to be
notified of and provide a list of RDS sources (\code{SourceIds}) that
triggers the events. You can also provide a list of event categories
(\code{EventCategories}) for events that you want to be notified of. For
example, you can specify \code{SourceType} = \code{db-instance}, \code{SourceIds} =
\code{mydbinstance1}, \code{mydbinstance2} and \code{EventCategories} = \code{Availability},
\code{Backup}.

If you specify both the \code{SourceType} and \code{SourceIds}, such as
\code{SourceType} = \code{db-instance} and \code{SourceIdentifier} = \code{myDBInstance1},
you are notified of all the \code{db-instance} events for the specified
source. If you specify a \code{SourceType} but do not specify a
\code{SourceIdentifier}, you receive notice of the events for that source
type for all your RDS sources. If you don't specify either the
SourceType or the \code{SourceIdentifier}, you are notified of events
generated from all RDS sources belonging to your customer account.

RDS event notification is only available for unencrypted SNS topics. If
you specify an encrypted SNS topic, event notifications aren't sent for
the topic.
}
\section{Request syntax}{
\preformatted{svc$create_event_subscription(
  SubscriptionName = "string",
  SnsTopicArn = "string",
  SourceType = "string",
  EventCategories = list(
    "string"
  ),
  SourceIds = list(
    "string"
  ),
  Enabled = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
