% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_instance_to_point_in_time}
\alias{rds_restore_db_instance_to_point_in_time}
\title{Restores a DB instance to an arbitrary point in time}
\usage{
rds_restore_db_instance_to_point_in_time(SourceDBInstanceIdentifier,
  TargetDBInstanceIdentifier, RestoreTime, UseLatestRestorableTime,
  DBInstanceClass, Port, AvailabilityZone, DBSubnetGroupName, MultiAZ,
  PubliclyAccessible, AutoMinorVersionUpgrade, LicenseModel, DBName,
  Engine, Iops, OptionGroupName, CopyTagsToSnapshot, Tags, StorageType,
  TdeCredentialArn, TdeCredentialPassword, VpcSecurityGroupIds, Domain,
  DomainIAMRoleName, EnableIAMDatabaseAuthentication,
  EnableCloudwatchLogsExports, ProcessorFeatures,
  UseDefaultProcessorFeatures, DBParameterGroupName, DeletionProtection,
  SourceDbiResourceId, MaxAllocatedStorage,
  SourceDBInstanceAutomatedBackupsArn, EnableCustomerOwnedIp)
}
\arguments{
\item{SourceDBInstanceIdentifier}{The identifier of the source DB instance from which to restore.

Constraints:
\itemize{
\item Must match the identifier of an existing DB instance.
}}

\item{TargetDBInstanceIdentifier}{[required] The name of the new DB instance to be created.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}}

\item{RestoreTime}{The date and time to restore from.

Valid Values: Value must be a time in Universal Coordinated Time (UTC)
format

Constraints:
\itemize{
\item Must be before the latest restorable time for the DB instance
\item Can't be specified if the \code{UseLatestRestorableTime} parameter is
enabled
}

Example: \verb{2009-09-07T23:45:00Z}}

\item{UseLatestRestorableTime}{A value that indicates whether the DB instance is restored from the
latest backup time. By default, the DB instance isn't restored from the
latest backup time.

Constraints: Can't be specified if the \code{RestoreTime} parameter is
provided.}

\item{DBInstanceClass}{The compute and memory capacity of the Amazon RDS DB instance, for
example, \code{db.m4.large}. Not all DB instance classes are available in all
AWS Regions, or for all database engines. For the full list of DB
instance classes, and availability for your engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB Instance Class}
in the \emph{Amazon RDS User Guide.}

Default: The same DBInstanceClass as the original DB instance.}

\item{Port}{The port number on which the database accepts connections.

Constraints: Value must be \code{1150-65535}

Default: The same port as the original DB instance.}

\item{AvailabilityZone}{The Availability Zone (AZ) where the DB instance will be created.

Default: A random, system-chosen Availability Zone.

Constraint: You can't specify the \code{AvailabilityZone} parameter if the DB
instance is a Multi-AZ deployment.

Example: \verb{us-east-1a}}

\item{DBSubnetGroupName}{The DB subnet group name to use for the new instance.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mySubnetgroup}}

\item{MultiAZ}{A value that indicates whether the DB instance is a Multi-AZ deployment.

Constraint: You can't specify the \code{AvailabilityZone} parameter if the DB
instance is a Multi-AZ deployment.}

\item{PubliclyAccessible}{A value that indicates whether the DB instance is publicly accessible.

When the DB instance is publicly accessible, its DNS endpoint resolves
to the private IP address from within the DB instance's VPC, and to the
public IP address from outside of the DB instance's VPC. Access to the
DB instance is ultimately controlled by the security group it uses, and
that public access is not permitted if the security group assigned to
the DB instance doesn't permit it.

When the DB instance isn't publicly accessible, it is an internal DB
instance with a DNS name that resolves to a private IP address.

For more information, see
\code{\link[=rds_create_db_instance]{create_db_instance}}.}

\item{AutoMinorVersionUpgrade}{A value that indicates whether minor version upgrades are applied
automatically to the DB instance during the maintenance window.}

\item{LicenseModel}{License model information for the restored DB instance.

Default: Same as source.

Valid values: \code{license-included} | \code{bring-your-own-license} |
\code{general-public-license}}

\item{DBName}{The database name for the restored DB instance.

This parameter isn't used for the MySQL or MariaDB engines.}

\item{Engine}{The database engine to use for the new instance.

Default: The same as source

Constraint: Must be compatible with the engine of the source

Valid Values:
\itemize{
\item \code{mariadb}
\item \code{mysql}
\item \code{oracle-ee}
\item \code{oracle-se2}
\item \code{oracle-se1}
\item \code{oracle-se}
\item \code{postgres}
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
be initially allocated for the DB instance.

Constraints: Must be an integer greater than 1000.

\strong{SQL Server}

Setting the IOPS value for the SQL Server database engine isn't
supported.}

\item{OptionGroupName}{The name of the option group to be used for the restored DB instance.

Permanent options, such as the TDE option for Oracle Advanced Security
TDE, can't be removed from an option group, and that option group can't
be removed from a DB instance once it is associated with a DB instance}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the restored DB
instance to snapshots of the DB instance. By default, tags are not
copied.}

\item{Tags}{}

\item{StorageType}{Specifies the storage type to be associated with the DB instance.

Valid values: \code{standard | gp2 | io1}

If you specify \code{io1}, you must also include a value for the \code{Iops}
parameter.

Default: \code{io1} if the \code{Iops} parameter is specified, otherwise \code{gp2}}

\item{TdeCredentialArn}{The ARN from the key store with which to associate the instance for TDE
encryption.}

\item{TdeCredentialPassword}{The password for the given ARN from the key store in order to access the
device.}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB instance.

Default: The default EC2 VPC security group for the DB subnet group's
VPC.}

\item{Domain}{Specify the Active Directory directory ID to restore the DB instance in.
The domain must be created prior to this operation. Currently, only
MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be
created in an Active Directory Domain.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon RDS User Guide}.}

\item{DomainIAMRoleName}{Specify the name of the IAM role to be used when making API calls to the
Directory Service.}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of AWS Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping is disabled.

For more information about IAM database authentication, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication for MySQL and PostgreSQL}
in the \emph{Amazon RDS User Guide.}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB instance is to export to
CloudWatch Logs. The values in the list depend on the DB engine being
used. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.}

\item{ProcessorFeatures}{The number of CPU cores and the number of threads per core for the DB
instance class of the DB instance.}

\item{UseDefaultProcessorFeatures}{A value that indicates whether the DB instance class of the DB instance
uses its default processor features.}

\item{DBParameterGroupName}{The name of the DB parameter group to associate with this DB instance.

If you do not specify a value for \code{DBParameterGroupName}, then the
default \code{DBParameterGroup} for the specified DB engine is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DBParameterGroup.
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}}

\item{DeletionProtection}{A value that indicates whether the DB instance has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection is disabled. For more
information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html}{Deleting a DB Instance}.}

\item{SourceDbiResourceId}{The resource ID of the source DB instance from which to restore.}

\item{MaxAllocatedStorage}{The upper limit to which Amazon RDS can automatically scale the storage
of the DB instance.}

\item{SourceDBInstanceAutomatedBackupsArn}{The Amazon Resource Name (ARN) of the replicated automated backups from
which to restore, for example,
\code{arn:aws:rds:useast-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE}.}

\item{EnableCustomerOwnedIp}{A value that indicates whether to enable a customer-owned IP address
(CoIP) for an RDS on Outposts DB instance.

A \emph{CoIP} provides local or external connectivity to resources in your
Outpost subnets through your on-premises network. For some use cases, a
CoIP can provide lower latency for connections to the DB instance from
outside of its virtual private cloud (VPC) on your local network.

For more information about RDS on Outposts, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html}{Working with Amazon RDS on AWS Outposts}
in the \emph{Amazon RDS User Guide}.

For more information about CoIPs, see \href{https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing}{Customer-owned IP addresses}
in the \emph{AWS Outposts User Guide}.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBInstance = list(
    DBInstanceIdentifier = "string",
    DBInstanceClass = "string",
    Engine = "string",
    DBInstanceStatus = "string",
    MasterUsername = "string",
    DBName = "string",
    Endpoint = list(
      Address = "string",
      Port = 123,
      HostedZoneId = "string"
    ),
    AllocatedStorage = 123,
    InstanceCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    PreferredBackupWindow = "string",
    BackupRetentionPeriod = 123,
    DBSecurityGroups = list(
      list(
        DBSecurityGroupName = "string",
        Status = "string"
      )
    ),
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    DBParameterGroups = list(
      list(
        DBParameterGroupName = "string",
        ParameterApplyStatus = "string"
      )
    ),
    AvailabilityZone = "string",
    DBSubnetGroup = list(
      DBSubnetGroupName = "string",
      DBSubnetGroupDescription = "string",
      VpcId = "string",
      SubnetGroupStatus = "string",
      Subnets = list(
        list(
          SubnetIdentifier = "string",
          SubnetAvailabilityZone = list(
            Name = "string"
          ),
          SubnetOutpost = list(
            Arn = "string"
          ),
          SubnetStatus = "string"
        )
      ),
      DBSubnetGroupArn = "string"
    ),
    PreferredMaintenanceWindow = "string",
    PendingModifiedValues = list(
      DBInstanceClass = "string",
      AllocatedStorage = 123,
      MasterUserPassword = "string",
      Port = 123,
      BackupRetentionPeriod = 123,
      MultiAZ = TRUE|FALSE,
      EngineVersion = "string",
      LicenseModel = "string",
      Iops = 123,
      DBInstanceIdentifier = "string",
      StorageType = "string",
      CACertificateIdentifier = "string",
      DBSubnetGroupName = "string",
      PendingCloudwatchLogsExports = list(
        LogTypesToEnable = list(
          "string"
        ),
        LogTypesToDisable = list(
          "string"
        )
      ),
      ProcessorFeatures = list(
        list(
          Name = "string",
          Value = "string"
        )
      ),
      IAMDatabaseAuthenticationEnabled = TRUE|FALSE
    ),
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    MultiAZ = TRUE|FALSE,
    EngineVersion = "string",
    AutoMinorVersionUpgrade = TRUE|FALSE,
    ReadReplicaSourceDBInstanceIdentifier = "string",
    ReadReplicaDBInstanceIdentifiers = list(
      "string"
    ),
    ReadReplicaDBClusterIdentifiers = list(
      "string"
    ),
    ReplicaMode = "open-read-only"|"mounted",
    LicenseModel = "string",
    Iops = 123,
    OptionGroupMemberships = list(
      list(
        OptionGroupName = "string",
        Status = "string"
      )
    ),
    CharacterSetName = "string",
    NcharCharacterSetName = "string",
    SecondaryAvailabilityZone = "string",
    PubliclyAccessible = TRUE|FALSE,
    StatusInfos = list(
      list(
        StatusType = "string",
        Normal = TRUE|FALSE,
        Status = "string",
        Message = "string"
      )
    ),
    StorageType = "string",
    TdeCredentialArn = "string",
    DbInstancePort = 123,
    DBClusterIdentifier = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbiResourceId = "string",
    CACertificateIdentifier = "string",
    DomainMemberships = list(
      list(
        Domain = "string",
        Status = "string",
        FQDN = "string",
        IAMRoleName = "string"
      )
    ),
    CopyTagsToSnapshot = TRUE|FALSE,
    MonitoringInterval = 123,
    EnhancedMonitoringResourceArn = "string",
    MonitoringRoleArn = "string",
    PromotionTier = 123,
    DBInstanceArn = "string",
    Timezone = "string",
    IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
    PerformanceInsightsEnabled = TRUE|FALSE,
    PerformanceInsightsKMSKeyId = "string",
    PerformanceInsightsRetentionPeriod = 123,
    EnabledCloudwatchLogsExports = list(
      "string"
    ),
    ProcessorFeatures = list(
      list(
        Name = "string",
        Value = "string"
      )
    ),
    DeletionProtection = TRUE|FALSE,
    AssociatedRoles = list(
      list(
        RoleArn = "string",
        FeatureName = "string",
        Status = "string"
      )
    ),
    ListenerEndpoint = list(
      Address = "string",
      Port = 123,
      HostedZoneId = "string"
    ),
    MaxAllocatedStorage = 123,
    TagList = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    DBInstanceAutomatedBackupsReplications = list(
      list(
        DBInstanceAutomatedBackupsArn = "string"
      )
    ),
    CustomerOwnedIpEnabled = TRUE|FALSE
  )
)
}
}
\description{
Restores a DB instance to an arbitrary point in time. You can restore to
any point in time before the time identified by the LatestRestorableTime
property. You can restore to a point up to the number of days specified
by the BackupRetentionPeriod property.

The target database is created with most of the original configuration,
but in a system-selected Availability Zone, with the default security
group, the default subnet group, and the default DB parameter group. By
default, the new DB instance is created as a single-AZ deployment except
when the instance is a SQL Server instance that has an option group that
is associated with mirroring; in this case, the instance becomes a
mirrored deployment and not a single-AZ deployment.

This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For
Aurora, use
\code{\link[=rds_restore_db_cluster_to_point_in_time]{restore_db_cluster_to_point_in_time}}.
}
\section{Request syntax}{
\preformatted{svc$restore_db_instance_to_point_in_time(
  SourceDBInstanceIdentifier = "string",
  TargetDBInstanceIdentifier = "string",
  RestoreTime = as.POSIXct(
    "2015-01-01"
  ),
  UseLatestRestorableTime = TRUE|FALSE,
  DBInstanceClass = "string",
  Port = 123,
  AvailabilityZone = "string",
  DBSubnetGroupName = "string",
  MultiAZ = TRUE|FALSE,
  PubliclyAccessible = TRUE|FALSE,
  AutoMinorVersionUpgrade = TRUE|FALSE,
  LicenseModel = "string",
  DBName = "string",
  Engine = "string",
  Iops = 123,
  OptionGroupName = "string",
  CopyTagsToSnapshot = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  StorageType = "string",
  TdeCredentialArn = "string",
  TdeCredentialPassword = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Domain = "string",
  DomainIAMRoleName = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  ProcessorFeatures = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  UseDefaultProcessorFeatures = TRUE|FALSE,
  DBParameterGroupName = "string",
  DeletionProtection = TRUE|FALSE,
  SourceDbiResourceId = "string",
  MaxAllocatedStorage = 123,
  SourceDBInstanceAutomatedBackupsArn = "string",
  EnableCustomerOwnedIp = TRUE|FALSE
)
}
}

\keyword{internal}
