% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_get_reserved_node_exchange_offerings}
\alias{redshift_get_reserved_node_exchange_offerings}
\title{Returns an array of DC2 ReservedNodeOfferings that matches the payment
type, term, and usage price of the given DC1 reserved node}
\usage{
redshift_get_reserved_node_exchange_offerings(ReservedNodeId,
  MaxRecords, Marker)
}
\arguments{
\item{ReservedNodeId}{[required] A string representing the node identifier for the DC1 Reserved Node to
be exchanged.}

\item{MaxRecords}{An integer setting the maximum number of ReservedNodeOfferings to
retrieve.}

\item{Marker}{A value that indicates the starting point for the next set of
ReservedNodeOfferings.}
}
\value{
A list with the following syntax:\preformatted{list(
  Marker = "string",
  ReservedNodeOfferings = list(
    list(
      ReservedNodeOfferingId = "string",
      NodeType = "string",
      Duration = 123,
      FixedPrice = 123.0,
      UsagePrice = 123.0,
      CurrencyCode = "string",
      OfferingType = "string",
      RecurringCharges = list(
        list(
          RecurringChargeAmount = 123.0,
          RecurringChargeFrequency = "string"
        )
      ),
      ReservedNodeOfferingType = "Regular"|"Upgradable"
    )
  )
)
}
}
\description{
Returns an array of DC2 ReservedNodeOfferings that matches the payment
type, term, and usage price of the given DC1 reserved node.
}
\section{Request syntax}{
\preformatted{svc$get_reserved_node_exchange_offerings(
  ReservedNodeId = "string",
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
