% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_authorize_cluster_security_group_ingress}
\alias{redshift_authorize_cluster_security_group_ingress}
\title{Adds an inbound (ingress) rule to an Amazon Redshift security group}
\usage{
redshift_authorize_cluster_security_group_ingress(
  ClusterSecurityGroupName,
  CIDRIP = NULL,
  EC2SecurityGroupName = NULL,
  EC2SecurityGroupOwnerId = NULL
)
}
\arguments{
\item{ClusterSecurityGroupName}{[required] The name of the security group to which the ingress rule is added.}

\item{CIDRIP}{The IP range to be added the Amazon Redshift security group.}

\item{EC2SecurityGroupName}{The EC2 security group to be added the Amazon Redshift security group.}

\item{EC2SecurityGroupOwnerId}{The Amazon Web Services account number of the owner of the security
group specified by the \emph{EC2SecurityGroupName} parameter. The Amazon Web
Services Access Key ID is not an acceptable value.

Example: \code{111122223333}}
}
\description{
Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as many as 20 ingress rules to an Amazon Redshift security group.

See \url{https://paws-r.github.io/docs/redshift/authorize_cluster_security_group_ingress.html} for full documentation.
}
\keyword{internal}
