% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timestreamwrite_operations.R
\name{timestreamwrite_create_database}
\alias{timestreamwrite_create_database}
\title{Creates a new Timestream database}
\usage{
timestreamwrite_create_database(DatabaseName, KmsKeyId = NULL, Tags = NULL)
}
\arguments{
\item{DatabaseName}{[required] The name of the Timestream database.}

\item{KmsKeyId}{The KMS key for the database. If the KMS key is not specified, the
database will be encrypted with a Timestream managed KMS key located in
your account. Refer to \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk}{Amazon Web Services managed KMS keys}
for more info.}

\item{Tags}{A list of key-value pairs to label the table.}
}
\description{
Creates a new Timestream database. If the KMS key is not specified, the database will be encrypted with a Timestream managed KMS key located in your account. Refer to \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk}{Amazon Web Services managed KMS keys} for more info. \href{https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html}{Service quotas apply}. See \href{https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-db.html}{code sample} for details.

See \url{https://paws-r.github.io/docs/timestreamwrite/create_database.html} for full documentation.
}
\keyword{internal}
