% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_describe_test_cases}
\alias{codebuild_describe_test_cases}
\title{Returns a list of details about test cases for a report}
\usage{
codebuild_describe_test_cases(
  reportArn,
  nextToken = NULL,
  maxResults = NULL,
  filter = NULL
)
}
\arguments{
\item{reportArn}{[required] The ARN of the report for which test cases are returned.}

\item{nextToken}{During a previous call, the maximum number of items that can be returned
is the value specified in \code{maxResults}. If there more items in the list,
then a unique string called a \emph{nextToken} is returned. To get the next
batch of items in the list, call this operation again, adding the next
token to the call. To get all of the items in the list, keep calling
this operation with each subsequent next token that is returned, until
no more next tokens are returned.}

\item{maxResults}{The maximum number of paginated test cases returned per response. Use
\code{nextToken} to iterate pages in the list of returned \code{TestCase} objects.
The default value is 100.}

\item{filter}{A \code{TestCaseFilter} object used to filter the returned reports.}
}
\description{
Returns a list of details about test cases for a report.

See \url{https://www.paws-r-sdk.com/docs/codebuild_describe_test_cases/} for full documentation.
}
\keyword{internal}
