% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_start_entities_detection_job}
\alias{comprehend_start_entities_detection_job}
\title{Starts an asynchronous entity detection job for a collection of
documents}
\usage{
comprehend_start_entities_detection_job(InputDataConfig,
  OutputDataConfig, DataAccessRoleArn, JobName, EntityRecognizerArn,
  LanguageCode, ClientRequestToken, VolumeKmsKeyId)
}
\arguments{
\item{InputDataConfig}{[required] Specifies the format and location of the input data for the job.}

\item{OutputDataConfig}{[required] Specifies where to send the output files.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the AWS Identity and Access Management
(IAM) role that grants Amazon Comprehend read access to your input data.
For more information, see
\url{https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions}.}

\item{JobName}{The identifier of the job.}

\item{EntityRecognizerArn}{The Amazon Resource Name (ARN) that identifies the specific entity
recognizer to be used by the \code{StartEntitiesDetectionJob}. This ARN is
optional and is only used for a custom entity recognition job.}

\item{LanguageCode}{[required] The language of the input documents. All documents must be in the same
language. You can specify any of the languages supported by Amazon
Comprehend: English ("en"), Spanish ("es"), French ("fr"), German
("de"), Italian ("it"), or Portuguese ("pt"). If custom entities
recognition is used, this parameter is ignored and the language used for
training the model is used instead.}

\item{ClientRequestToken}{A unique identifier for the request. If you don't set the client
request token, Amazon Comprehend generates one.}

\item{VolumeKmsKeyId}{ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
uses to encrypt data on the storage volume attached to the ML compute
instance(s) that process the analysis job. The VolumeKmsKeyId can be
either of the following formats:
\itemize{
\item KMS Key ID: \code{"1234abcd-12ab-34cd-56ef-1234567890ab"}
\item Amazon Resource Name (ARN) of a KMS Key:
\code{"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"}
}}
}
\description{
Starts an asynchronous entity detection job for a collection of
documents. Use the operation to track the status of a job.
}
\details{
This API can be used for either standard entity detection or custom
entity recognition. In order to be used for custom entity recognition,
the optional \code{EntityRecognizerArn} must be used in order to provide
access to the recognizer being used to detect the custom entity.
}
\section{Request syntax}{
\preformatted{svc$start_entities_detection_job(
  InputDataConfig = list(
    S3Uri = "string",
    InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
  ),
  OutputDataConfig = list(
    S3Uri = "string",
    KmsKeyId = "string"
  ),
  DataAccessRoleArn = "string",
  JobName = "string",
  EntityRecognizerArn = "string",
  LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt",
  ClientRequestToken = "string",
  VolumeKmsKeyId = "string"
)
}
}

\keyword{internal}
