% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_start_import}
\alias{lexmodelbuildingservice_start_import}
\title{Starts a job to import a resource to Amazon Lex}
\usage{
lexmodelbuildingservice_start_import(payload, resourceType,
  mergeStrategy)
}
\arguments{
\item{payload}{[required] A zip archive in binary format. The archive should contain one file, a
JSON file containing the resource to import. The resource should match
the type specified in the \code{resourceType} field.}

\item{resourceType}{[required] Specifies the type of resource to export. Each resource also exports any
resources that it depends on.
\itemize{
\item A bot exports dependent intents.
\item An intent exports dependent slot types.
}}

\item{mergeStrategy}{[required] Specifies the action that the \code{StartImport} operation should take when
there is an existing resource with the same name.
\itemize{
\item FAIL\_ON\_CONFLICT - The import operation is stopped on the first
conflict between a resource in the import file and an existing
resource. The name of the resource causing the conflict is in the
\code{failureReason} field of the response to the \code{GetImport} operation.

OVERWRITE\_LATEST - The import operation proceeds even if there is a
conflict with an existing resource. The \$LASTEST version of the
existing resource is overwritten with the data from the import file.
}}
}
\description{
Starts a job to import a resource to Amazon Lex.
}
\section{Request syntax}{
\preformatted{svc$start_import(
  payload = raw,
  resourceType = "BOT"|"INTENT"|"SLOT_TYPE",
  mergeStrategy = "OVERWRITE_LATEST"|"FAIL_ON_CONFLICT"
)
}
}

\keyword{internal}
