% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textract_operations.R
\name{textract_analyze_document}
\alias{textract_analyze_document}
\title{Analyzes an input document for relationships in the detected text and
tables}
\usage{
textract_analyze_document(Document, FeatureTypes)
}
\arguments{
\item{Document}{[required] The input document as base64-encoded bytes or an Amazon S3 object. If
you use the AWS CLI to call Amazon Textract operations, you can't pass
image bytes. The document must be an image in JPG or PNG format.}

\item{FeatureTypes}{[required] A list of the types of analysis to perform. Add TABLES to the list to
return information about the tables detected in the input document. Add
FORMS to return detected fields and the associated text. To perform both
types of analysis, add TABLES and FORMS to \code{FeatureTypes}.}
}
\description{
Analyzes an input document for relationships in the detected text and
tables.
}
\details{
Two types of information are returned:
\itemize{
\item Words and lines that are related to nearby lines and words. The
related information is returned in two Block objects: a KEY Block
object and a VALUE Block object. For example, \emph{Name: Ana Silva
Carolina} contains a key and value. \emph{Name:} is the key. \emph{Ana Silva
Carolina} is the value.
\item Table and table cell data. A TABLE Block contains information about
a detected table. A CELL block is returned for each cell in a table.
}

You can choose which type of analysis to perform by specifying the
\code{FeatureTypes} list.

The output is returned in a list of \code{BLOCK} objects (Blocks). For more
information, see how-it-works-analyzing.

\code{AnalyzeDocument} is a synchronous operation. To analyze documents
asynchronously, use StartDocumentAnalysis.
}
\section{Request syntax}{
\preformatted{svc$analyze_document(
  Document = list(
    Bytes = raw,
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  FeatureTypes = list(
    "TABLES"|"FORMS"
  )
)
}
}

\keyword{internal}
