% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_start_events_detection_job}
\alias{comprehend_start_events_detection_job}
\title{Starts an asynchronous event detection job for a collection of documents}
\usage{
comprehend_start_events_detection_job(InputDataConfig, OutputDataConfig,
  DataAccessRoleArn, JobName, LanguageCode, ClientRequestToken,
  TargetEventTypes)
}
\arguments{
\item{InputDataConfig}{[required] Specifies the format and location of the input data for the job.}

\item{OutputDataConfig}{[required] Specifies where to send the output files.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the AWS Identity and Access Management
(IAM) role that grants Amazon Comprehend read access to your input data.}

\item{JobName}{The identifier of the events detection job.}

\item{LanguageCode}{[required] The language code of the input documents.}

\item{ClientRequestToken}{An unique identifier for the request. If you don't set the client
request token, Amazon Comprehend generates one.}

\item{TargetEventTypes}{[required] The types of events to detect in the input documents.}
}
\description{
Starts an asynchronous event detection job for a collection of
documents.
}
\section{Request syntax}{
\preformatted{svc$start_events_detection_job(
  InputDataConfig = list(
    S3Uri = "string",
    InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
  ),
  OutputDataConfig = list(
    S3Uri = "string",
    KmsKeyId = "string"
  ),
  DataAccessRoleArn = "string",
  JobName = "string",
  LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
  ClientRequestToken = "string",
  TargetEventTypes = list(
    "string"
  )
)
}
}

\keyword{internal}
