% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_describe_recipe}
\alias{personalize_describe_recipe}
\title{Describes a recipe}
\usage{
personalize_describe_recipe(recipeArn)
}
\arguments{
\item{recipeArn}{[required] The Amazon Resource Name (ARN) of the recipe to describe.}
}
\description{
Describes a recipe.

A recipe contains three items:
\itemize{
\item An algorithm that trains a model.
\item Hyperparameters that govern the training.
\item Feature transformation information for modifying the input data
before training.
}

Amazon Personalize provides a set of predefined recipes. You specify a
recipe when you create a solution with the CreateSolution API.
\code{CreateSolution} trains a model by using the algorithm in the specified
recipe and a training dataset. The solution, when deployed as a
campaign, can provide recommendations using the
\href{https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html}{GetRecommendations}
API.
}
\section{Request syntax}{
\preformatted{svc$describe_recipe(
  recipeArn = "string"
)
}
}

\keyword{internal}
