% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemakerruntime_service.R
\name{sagemakerruntime}
\alias{sagemakerruntime}
\title{Amazon SageMaker Runtime}
\usage{
sagemakerruntime(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
The Amazon SageMaker runtime API.
}
\section{Service syntax}{
\preformatted{svc <- sagemakerruntime(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=sagemakerruntime_invoke_endpoint]{invoke_endpoint} \tab After you deploy a model into production using Amazon SageMaker hosting services, your client applications use this API to get inferences from the model hosted at the specified endpoint
}
}

\examples{
\dontrun{
svc <- sagemakerruntime()
svc$invoke_endpoint(
  Foo = 123
)
}

}
