% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_device_fleet}
\alias{sagemaker_create_device_fleet}
\title{Creates a device fleet}
\usage{
sagemaker_create_device_fleet(DeviceFleetName, RoleArn, Description,
  OutputConfig, Tags)
}
\arguments{
\item{DeviceFleetName}{[required] The name of the fleet that the device belongs to.}

\item{RoleArn}{The Amazon Resource Name (ARN) that has access to AWS Internet of Things
(IoT).}

\item{Description}{A description of the fleet.}

\item{OutputConfig}{[required] The output configuration for storing sample data collected by the fleet.}

\item{Tags}{Creates tags for the specified fleet.}
}
\value{
An empty list.
}
\description{
Creates a device fleet.
}
\section{Request syntax}{
\preformatted{svc$create_device_fleet(
  DeviceFleetName = "string",
  RoleArn = "string",
  Description = "string",
  OutputConfig = list(
    S3OutputLocation = "string",
    KmsKeyId = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
