% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_delete_endpoint}
\alias{sagemaker_delete_endpoint}
\title{Deletes an endpoint}
\usage{
sagemaker_delete_endpoint(EndpointName)
}
\arguments{
\item{EndpointName}{[required] The name of the endpoint that you want to delete.}
}
\value{
An empty list.
}
\description{
Deletes an endpoint. Amazon SageMaker frees up all of the resources that
were deployed when the endpoint was created.

Amazon SageMaker retires any custom KMS key grants associated with the
endpoint, meaning you don't need to use the
\href{https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html}{RevokeGrant}
API call.
}
\section{Request syntax}{
\preformatted{svc$delete_endpoint(
  EndpointName = "string"
)
}
}

\keyword{internal}
