% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_describe_model_package}
\alias{sagemaker_describe_model_package}
\title{Returns a description of the specified model package, which is used to
create Amazon SageMaker models or list them on AWS Marketplace}
\usage{
sagemaker_describe_model_package(ModelPackageName)
}
\arguments{
\item{ModelPackageName}{[required] The name of the model package to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  ModelPackageName = "string",
  ModelPackageGroupName = "string",
  ModelPackageVersion = 123,
  ModelPackageArn = "string",
  ModelPackageDescription = "string",
  CreationTime = as.POSIXct(
    "2015-01-01"
  ),
  InferenceSpecification = list(
    Containers = list(
      list(
        ContainerHostname = "string",
        Image = "string",
        ImageDigest = "string",
        ModelDataUrl = "string",
        ProductId = "string"
      )
    ),
    SupportedTransformInstanceTypes = list(
      "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"
    ),
    SupportedRealtimeInferenceInstanceTypes = list(
      "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.m5d.large"|"ml.m5d.xlarge"|"ml.m5d.2xlarge"|"ml.m5d.4xlarge"|"ml.m5d.12xlarge"|"ml.m5d.24xlarge"|"ml.c4.large"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5d.large"|"ml.c5d.xlarge"|"ml.c5d.2xlarge"|"ml.c5d.4xlarge"|"ml.c5d.9xlarge"|"ml.c5d.18xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.12xlarge"|"ml.r5.24xlarge"|"ml.r5d.large"|"ml.r5d.xlarge"|"ml.r5d.2xlarge"|"ml.r5d.4xlarge"|"ml.r5d.12xlarge"|"ml.r5d.24xlarge"|"ml.inf1.xlarge"|"ml.inf1.2xlarge"|"ml.inf1.6xlarge"|"ml.inf1.24xlarge"
    ),
    SupportedContentTypes = list(
      "string"
    ),
    SupportedResponseMIMETypes = list(
      "string"
    )
  ),
  SourceAlgorithmSpecification = list(
    SourceAlgorithms = list(
      list(
        ModelDataUrl = "string",
        AlgorithmName = "string"
      )
    )
  ),
  ValidationSpecification = list(
    ValidationRole = "string",
    ValidationProfiles = list(
      list(
        ProfileName = "string",
        TransformJobDefinition = list(
          MaxConcurrentTransforms = 123,
          MaxPayloadInMB = 123,
          BatchStrategy = "MultiRecord"|"SingleRecord",
          Environment = list(
            "string"
          ),
          TransformInput = list(
            DataSource = list(
              S3DataSource = list(
                S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
                S3Uri = "string"
              )
            ),
            ContentType = "string",
            CompressionType = "None"|"Gzip",
            SplitType = "None"|"Line"|"RecordIO"|"TFRecord"
          ),
          TransformOutput = list(
            S3OutputPath = "string",
            Accept = "string",
            AssembleWith = "None"|"Line",
            KmsKeyId = "string"
          ),
          TransformResources = list(
            InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge",
            InstanceCount = 123,
            VolumeKmsKeyId = "string"
          )
        )
      )
    )
  ),
  ModelPackageStatus = "Pending"|"InProgress"|"Completed"|"Failed"|"Deleting",
  ModelPackageStatusDetails = list(
    ValidationStatuses = list(
      list(
        Name = "string",
        Status = "NotStarted"|"InProgress"|"Completed"|"Failed",
        FailureReason = "string"
      )
    ),
    ImageScanStatuses = list(
      list(
        Name = "string",
        Status = "NotStarted"|"InProgress"|"Completed"|"Failed",
        FailureReason = "string"
      )
    )
  ),
  CertifyForMarketplace = TRUE|FALSE,
  ModelApprovalStatus = "Approved"|"Rejected"|"PendingManualApproval",
  CreatedBy = list(
    UserProfileArn = "string",
    UserProfileName = "string",
    DomainId = "string"
  ),
  MetadataProperties = list(
    CommitId = "string",
    Repository = "string",
    GeneratedBy = "string",
    ProjectId = "string"
  ),
  ModelMetrics = list(
    ModelQuality = list(
      Statistics = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      ),
      Constraints = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      )
    ),
    ModelDataQuality = list(
      Statistics = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      ),
      Constraints = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      )
    ),
    Bias = list(
      Report = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      )
    ),
    Explainability = list(
      Report = list(
        ContentType = "string",
        ContentDigest = "string",
        S3Uri = "string"
      )
    )
  ),
  LastModifiedTime = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedBy = list(
    UserProfileArn = "string",
    UserProfileName = "string",
    DomainId = "string"
  ),
  ApprovalDescription = "string"
)
}
}
\description{
Returns a description of the specified model package, which is used to
create Amazon SageMaker models or list them on AWS Marketplace.

To create models in Amazon SageMaker, buyers can subscribe to model
packages listed on AWS Marketplace.
}
\section{Request syntax}{
\preformatted{svc$describe_model_package(
  ModelPackageName = "string"
)
}
}

\keyword{internal}
