% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_list_recipes}
\alias{personalize_list_recipes}
\title{Returns a list of available recipes}
\usage{
personalize_list_recipes(recipeProvider, nextToken, maxResults)
}
\arguments{
\item{recipeProvider}{The default is \code{SERVICE}.}

\item{nextToken}{A token returned from the previous call to
\code{\link[=personalize_list_recipes]{list_recipes}} for getting the next set of
recipes (if they exist).}

\item{maxResults}{The maximum number of recipes to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  recipes = list(
    list(
      name = "string",
      recipeArn = "string",
      status = "string",
      creationDateTime = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedDateTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Returns a list of available recipes. The response provides the
properties for each recipe, including the recipe's Amazon Resource Name
(ARN).
}
\section{Request syntax}{
\preformatted{svc$list_recipes(
  recipeProvider = "SERVICE",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
