% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_delete_domain}
\alias{sagemaker_delete_domain}
\title{Used to delete a domain}
\usage{
sagemaker_delete_domain(DomainId, RetentionPolicy)
}
\arguments{
\item{DomainId}{[required] The domain ID.}

\item{RetentionPolicy}{The retention policy for this domain, which specifies whether resources
will be retained after the Domain is deleted. By default, all resources
are retained (not automatically deleted).}
}
\value{
An empty list.
}
\description{
Used to delete a domain. If you onboarded with IAM mode, you will need
to delete your domain to onboard again using SSO. Use with caution. All
of the members of the domain will lose access to their EFS volume,
including data, notebooks, and other artifacts.
}
\section{Request syntax}{
\preformatted{svc$delete_domain(
  DomainId = "string",
  RetentionPolicy = list(
    HomeEfsFileSystem = "Retain"|"Delete"
  )
)
}
}

\keyword{internal}
